/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.autopilot.v1.assistant.task.TaskStatisticsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskStatistics
extends Resource {
    private static final long serialVersionUID = 52568493998911L;
    private final String accountSid;
    private final String assistantSid;
    private final String taskSid;
    private final Integer samplesCount;
    private final Integer fieldsCount;
    private final URI url;

    public static TaskStatisticsFetcher fetcher(String pathAssistantSid, String pathTaskSid) {
        return new TaskStatisticsFetcher(pathAssistantSid, pathTaskSid);
    }

    public static TaskStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (TaskStatistics)objectMapper.readValue(json, TaskStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TaskStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (TaskStatistics)objectMapper.readValue(json, TaskStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TaskStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="task_sid") String taskSid, @JsonProperty(value="samples_count") Integer samplesCount, @JsonProperty(value="fields_count") Integer fieldsCount, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.assistantSid = assistantSid;
        this.taskSid = taskSid;
        this.samplesCount = samplesCount;
        this.fieldsCount = fieldsCount;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final String getTaskSid() {
        return this.taskSid;
    }

    public final Integer getSamplesCount() {
        return this.samplesCount;
    }

    public final Integer getFieldsCount() {
        return this.fieldsCount;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskStatistics other = (TaskStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.taskSid, other.taskSid) && Objects.equals(this.samplesCount, other.samplesCount) && Objects.equals(this.fieldsCount, other.fieldsCount) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.assistantSid, this.taskSid, this.samplesCount, this.fieldsCount, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("assistantSid", (Object)this.assistantSid).add("taskSid", (Object)this.taskSid).add("samplesCount", (Object)this.samplesCount).add("fieldsCount", (Object)this.fieldsCount).add("url", (Object)this.url).toString();
    }
}

