/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant.task;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.assistant.task.TaskActions;
import java.util.Map;

public class TaskActionsUpdater
extends Updater<TaskActions> {
    private final String pathAssistantSid;
    private final String pathTaskSid;
    private Map<String, Object> actions;

    public TaskActionsUpdater(String pathAssistantSid, String pathTaskSid) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathTaskSid = pathTaskSid;
    }

    public TaskActionsUpdater setActions(Map<String, Object> actions) {
        this.actions = actions;
        return this;
    }

    @Override
    public TaskActions update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTOPILOT.toString(), "/v1/Assistants/" + this.pathAssistantSid + "/Tasks/" + this.pathTaskSid + "/Actions");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskActions update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return TaskActions.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.actions != null) {
            request.addPostParam("Actions", Converter.mapToJson(this.actions));
        }
    }
}

