/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.assistant.Defaults;

public class DefaultsFetcher
extends Fetcher<Defaults> {
    private final String pathAssistantSid;

    public DefaultsFetcher(String pathAssistantSid) {
        this.pathAssistantSid = pathAssistantSid;
    }

    @Override
    public Defaults fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.AUTOPILOT.toString(), "/v1/Assistants/" + this.pathAssistantSid + "/Defaults");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Defaults fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Defaults.fromJson(response.getStream(), client.getObjectMapper());
    }
}

