/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.recording.addonresult;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.recording.addonresult.PayloadDeleter;
import com.twilio.rest.api.v2010.account.recording.addonresult.PayloadFetcher;
import com.twilio.rest.api.v2010.account.recording.addonresult.PayloadReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Payload
extends Resource {
    private static final long serialVersionUID = 217671696000636L;
    private final String sid;
    private final String addOnResultSid;
    private final String accountSid;
    private final String label;
    private final String addOnSid;
    private final String addOnConfigurationSid;
    private final String contentType;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String referenceSid;
    private final Map<String, String> subresourceUris;

    public static PayloadFetcher fetcher(String pathAccountSid, String pathReferenceSid, String pathAddOnResultSid, String pathSid) {
        return new PayloadFetcher(pathAccountSid, pathReferenceSid, pathAddOnResultSid, pathSid);
    }

    public static PayloadFetcher fetcher(String pathReferenceSid, String pathAddOnResultSid, String pathSid) {
        return new PayloadFetcher(pathReferenceSid, pathAddOnResultSid, pathSid);
    }

    public static PayloadReader reader(String pathAccountSid, String pathReferenceSid, String pathAddOnResultSid) {
        return new PayloadReader(pathAccountSid, pathReferenceSid, pathAddOnResultSid);
    }

    public static PayloadReader reader(String pathReferenceSid, String pathAddOnResultSid) {
        return new PayloadReader(pathReferenceSid, pathAddOnResultSid);
    }

    public static PayloadDeleter deleter(String pathAccountSid, String pathReferenceSid, String pathAddOnResultSid, String pathSid) {
        return new PayloadDeleter(pathAccountSid, pathReferenceSid, pathAddOnResultSid, pathSid);
    }

    public static PayloadDeleter deleter(String pathReferenceSid, String pathAddOnResultSid, String pathSid) {
        return new PayloadDeleter(pathReferenceSid, pathAddOnResultSid, pathSid);
    }

    public static Payload fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Payload)objectMapper.readValue(json, Payload.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Payload fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Payload)objectMapper.readValue(json, Payload.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Payload(@JsonProperty(value="sid") String sid, @JsonProperty(value="add_on_result_sid") String addOnResultSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="label") String label, @JsonProperty(value="add_on_sid") String addOnSid, @JsonProperty(value="add_on_configuration_sid") String addOnConfigurationSid, @JsonProperty(value="content_type") String contentType, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="reference_sid") String referenceSid, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris) {
        this.sid = sid;
        this.addOnResultSid = addOnResultSid;
        this.accountSid = accountSid;
        this.label = label;
        this.addOnSid = addOnSid;
        this.addOnConfigurationSid = addOnConfigurationSid;
        this.contentType = contentType;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.referenceSid = referenceSid;
        this.subresourceUris = subresourceUris;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAddOnResultSid() {
        return this.addOnResultSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getAddOnSid() {
        return this.addOnSid;
    }

    public final String getAddOnConfigurationSid() {
        return this.addOnConfigurationSid;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getReferenceSid() {
        return this.referenceSid;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payload other = (Payload)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.addOnResultSid, other.addOnResultSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.label, other.label) && Objects.equals(this.addOnSid, other.addOnSid) && Objects.equals(this.addOnConfigurationSid, other.addOnConfigurationSid) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.referenceSid, other.referenceSid) && Objects.equals(this.subresourceUris, other.subresourceUris);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.addOnResultSid, this.accountSid, this.label, this.addOnSid, this.addOnConfigurationSid, this.contentType, this.dateCreated, this.dateUpdated, this.referenceSid, this.subresourceUris);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("addOnResultSid", (Object)this.addOnResultSid).add("accountSid", (Object)this.accountSid).add("label", (Object)this.label).add("addOnSid", (Object)this.addOnSid).add("addOnConfigurationSid", (Object)this.addOnConfigurationSid).add("contentType", (Object)this.contentType).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("referenceSid", (Object)this.referenceSid).add("subresourceUris", this.subresourceUris).toString();
    }
}

