/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.RecordingDeleter;
import com.twilio.rest.api.v2010.account.RecordingFetcher;
import com.twilio.rest.api.v2010.account.RecordingReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Recording
extends Resource {
    private static final long serialVersionUID = 90678482961517L;
    private final String accountSid;
    private final String apiVersion;
    private final String callSid;
    private final String conferenceSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final DateTime startTime;
    private final String duration;
    private final String sid;
    private final String price;
    private final String priceUnit;
    private final Status status;
    private final Integer channels;
    private final Source source;
    private final Integer errorCode;
    private final String uri;
    private final Map<String, Object> encryptionDetails;
    private final Map<String, String> subresourceUris;

    public static RecordingFetcher fetcher(String pathAccountSid, String pathSid) {
        return new RecordingFetcher(pathAccountSid, pathSid);
    }

    public static RecordingFetcher fetcher(String pathSid) {
        return new RecordingFetcher(pathSid);
    }

    public static RecordingDeleter deleter(String pathAccountSid, String pathSid) {
        return new RecordingDeleter(pathAccountSid, pathSid);
    }

    public static RecordingDeleter deleter(String pathSid) {
        return new RecordingDeleter(pathSid);
    }

    public static RecordingReader reader(String pathAccountSid) {
        return new RecordingReader(pathAccountSid);
    }

    public static RecordingReader reader() {
        return new RecordingReader();
    }

    public static Recording fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Recording)objectMapper.readValue(json, Recording.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Recording fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Recording)objectMapper.readValue(json, Recording.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Recording(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="conference_sid") String conferenceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="duration") String duration, @JsonProperty(value="sid") String sid, @JsonProperty(value="price") String price, @JsonProperty(value="price_unit") String priceUnit, @JsonProperty(value="status") Status status, @JsonProperty(value="channels") Integer channels, @JsonProperty(value="source") Source source, @JsonProperty(value="error_code") Integer errorCode, @JsonProperty(value="uri") String uri, @JsonProperty(value="encryption_details") Map<String, Object> encryptionDetails, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.callSid = callSid;
        this.conferenceSid = conferenceSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.startTime = DateConverter.rfc2822DateTimeFromString(startTime);
        this.duration = duration;
        this.sid = sid;
        this.price = price;
        this.priceUnit = priceUnit;
        this.status = status;
        this.channels = channels;
        this.source = source;
        this.errorCode = errorCode;
        this.uri = uri;
        this.encryptionDetails = encryptionDetails;
        this.subresourceUris = subresourceUris;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getConferenceSid() {
        return this.conferenceSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final DateTime getStartTime() {
        return this.startTime;
    }

    public final String getDuration() {
        return this.duration;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getPrice() {
        return this.price;
    }

    public final String getPriceUnit() {
        return this.priceUnit;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Integer getChannels() {
        return this.channels;
    }

    public final Source getSource() {
        return this.source;
    }

    public final Integer getErrorCode() {
        return this.errorCode;
    }

    public final String getUri() {
        return this.uri;
    }

    public final Map<String, Object> getEncryptionDetails() {
        return this.encryptionDetails;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recording other = (Recording)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.conferenceSid, other.conferenceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.duration, other.duration) && Objects.equals(this.sid, other.sid) && Objects.equals(this.price, other.price) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.channels, other.channels) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.uri, other.uri) && Objects.equals(this.encryptionDetails, other.encryptionDetails) && Objects.equals(this.subresourceUris, other.subresourceUris);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.callSid, this.conferenceSid, this.dateCreated, this.dateUpdated, this.startTime, this.duration, this.sid, this.price, this.priceUnit, this.status, this.channels, this.source, this.errorCode, this.uri, this.encryptionDetails, this.subresourceUris});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("apiVersion", (Object)this.apiVersion).add("callSid", (Object)this.callSid).add("conferenceSid", (Object)this.conferenceSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("startTime", (Object)this.startTime).add("duration", (Object)this.duration).add("sid", (Object)this.sid).add("price", (Object)this.price).add("priceUnit", (Object)this.priceUnit).add("status", (Object)this.status).add("channels", (Object)this.channels).add("source", (Object)this.source).add("errorCode", (Object)this.errorCode).add("uri", (Object)this.uri).add("encryptionDetails", this.encryptionDetails).add("subresourceUris", this.subresourceUris).toString();
    }

    public static enum Source {
        DIALVERB("DialVerb"),
        CONFERENCE("Conference"),
        OUTBOUNDAPI("OutboundAPI"),
        TRUNKING("Trunking"),
        RECORDVERB("RecordVerb"),
        STARTCALLRECORDINGAPI("StartCallRecordingAPI"),
        STARTCONFERENCERECORDINGAPI("StartConferenceRecordingAPI");

        private final String value;

        private Source(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Source forValue(String value) {
            return (Source)Promoter.enumFromString((String)value, (Enum[])Source.values());
        }
    }

    public static enum Status {
        IN_PROGRESS("in-progress"),
        PAUSED("paused"),
        STOPPED("stopped"),
        PROCESSING("processing"),
        COMPLETED("completed"),
        ABSENT("absent");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

