/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Message;
import com.twilio.type.PhoneNumber;
import java.math.BigDecimal;
import java.net.URI;
import java.util.List;

public class MessageCreator
extends Creator<Message> {
    private String pathAccountSid;
    private final PhoneNumber to;
    private PhoneNumber from;
    private String messagingServiceSid;
    private String body;
    private List<URI> mediaUrl;
    private URI statusCallback;
    private String applicationSid;
    private BigDecimal maxPrice;
    private Boolean provideFeedback;
    private Integer attempt;
    private Integer validityPeriod;
    private Boolean forceDelivery;
    private Message.ContentRetention contentRetention;
    private Message.AddressRetention addressRetention;
    private Boolean smartEncoded;
    private List<String> persistentAction;

    public MessageCreator(PhoneNumber to, PhoneNumber from, String body) {
        this.to = to;
        this.from = from;
        this.body = body;
    }

    public MessageCreator(String pathAccountSid, PhoneNumber to, PhoneNumber from, String body) {
        this.pathAccountSid = pathAccountSid;
        this.to = to;
        this.from = from;
        this.body = body;
    }

    public MessageCreator(PhoneNumber to, PhoneNumber from, List<URI> mediaUrl) {
        this.to = to;
        this.from = from;
        this.mediaUrl = mediaUrl;
    }

    public MessageCreator(String pathAccountSid, PhoneNumber to, PhoneNumber from, List<URI> mediaUrl) {
        this.pathAccountSid = pathAccountSid;
        this.to = to;
        this.from = from;
        this.mediaUrl = mediaUrl;
    }

    public MessageCreator(PhoneNumber to, String messagingServiceSid, String body) {
        this.to = to;
        this.messagingServiceSid = messagingServiceSid;
        this.body = body;
    }

    public MessageCreator(String pathAccountSid, PhoneNumber to, String messagingServiceSid, String body) {
        this.pathAccountSid = pathAccountSid;
        this.to = to;
        this.messagingServiceSid = messagingServiceSid;
        this.body = body;
    }

    public MessageCreator(PhoneNumber to, String messagingServiceSid, List<URI> mediaUrl) {
        this.to = to;
        this.messagingServiceSid = messagingServiceSid;
        this.mediaUrl = mediaUrl;
    }

    public MessageCreator(String pathAccountSid, PhoneNumber to, String messagingServiceSid, List<URI> mediaUrl) {
        this.pathAccountSid = pathAccountSid;
        this.to = to;
        this.messagingServiceSid = messagingServiceSid;
        this.mediaUrl = mediaUrl;
    }

    public MessageCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public MessageCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public MessageCreator setApplicationSid(String applicationSid) {
        this.applicationSid = applicationSid;
        return this;
    }

    public MessageCreator setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
        return this;
    }

    public MessageCreator setProvideFeedback(Boolean provideFeedback) {
        this.provideFeedback = provideFeedback;
        return this;
    }

    public MessageCreator setAttempt(Integer attempt) {
        this.attempt = attempt;
        return this;
    }

    public MessageCreator setValidityPeriod(Integer validityPeriod) {
        this.validityPeriod = validityPeriod;
        return this;
    }

    public MessageCreator setForceDelivery(Boolean forceDelivery) {
        this.forceDelivery = forceDelivery;
        return this;
    }

    public MessageCreator setContentRetention(Message.ContentRetention contentRetention) {
        this.contentRetention = contentRetention;
        return this;
    }

    public MessageCreator setAddressRetention(Message.AddressRetention addressRetention) {
        this.addressRetention = addressRetention;
        return this;
    }

    public MessageCreator setSmartEncoded(Boolean smartEncoded) {
        this.smartEncoded = smartEncoded;
        return this;
    }

    public MessageCreator setPersistentAction(List<String> persistentAction) {
        this.persistentAction = persistentAction;
        return this;
    }

    public MessageCreator setPersistentAction(String persistentAction) {
        return this.setPersistentAction(Promoter.listOfOne(persistentAction));
    }

    public MessageCreator setFrom(PhoneNumber from) {
        this.from = from;
        return this;
    }

    public MessageCreator setFrom(String from) {
        return this.setFrom(Promoter.phoneNumberFromString(from));
    }

    public MessageCreator setMessagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
        return this;
    }

    public MessageCreator setBody(String body) {
        this.body = body;
        return this;
    }

    public MessageCreator setMediaUrl(List<URI> mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    public MessageCreator setMediaUrl(URI mediaUrl) {
        return this.setMediaUrl(Promoter.listOfOne(mediaUrl));
    }

    public MessageCreator setMediaUrl(String mediaUrl) {
        return this.setMediaUrl(Promoter.uriFromString(mediaUrl));
    }

    @Override
    public Message create(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Messages.json");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Message creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Message.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.to != null) {
            request.addPostParam("To", this.to.toString());
        }
        if (this.from != null) {
            request.addPostParam("From", this.from.toString());
        }
        if (this.messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", this.messagingServiceSid);
        }
        if (this.body != null) {
            request.addPostParam("Body", this.body);
        }
        if (this.mediaUrl != null) {
            for (URI uRI : this.mediaUrl) {
                request.addPostParam("MediaUrl", uRI.toString());
            }
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.applicationSid != null) {
            request.addPostParam("ApplicationSid", this.applicationSid);
        }
        if (this.maxPrice != null) {
            request.addPostParam("MaxPrice", this.maxPrice.toString());
        }
        if (this.provideFeedback != null) {
            request.addPostParam("ProvideFeedback", this.provideFeedback.toString());
        }
        if (this.attempt != null) {
            request.addPostParam("Attempt", this.attempt.toString());
        }
        if (this.validityPeriod != null) {
            request.addPostParam("ValidityPeriod", this.validityPeriod.toString());
        }
        if (this.forceDelivery != null) {
            request.addPostParam("ForceDelivery", this.forceDelivery.toString());
        }
        if (this.contentRetention != null) {
            request.addPostParam("ContentRetention", this.contentRetention.toString());
        }
        if (this.addressRetention != null) {
            request.addPostParam("AddressRetention", this.addressRetention.toString());
        }
        if (this.smartEncoded != null) {
            request.addPostParam("SmartEncoded", this.smartEncoded.toString());
        }
        if (this.persistentAction != null) {
            for (String string : this.persistentAction) {
                request.addPostParam("PersistentAction", string);
            }
        }
    }
}

