/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.AvailablePhoneNumberCountryFetcher;
import com.twilio.rest.api.v2010.account.AvailablePhoneNumberCountryReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AvailablePhoneNumberCountry
extends Resource {
    private static final long serialVersionUID = 118317602820324L;
    private final String countryCode;
    private final String country;
    private final URI uri;
    private final Boolean beta;
    private final Map<String, String> subresourceUris;

    public static AvailablePhoneNumberCountryReader reader(String pathAccountSid) {
        return new AvailablePhoneNumberCountryReader(pathAccountSid);
    }

    public static AvailablePhoneNumberCountryReader reader() {
        return new AvailablePhoneNumberCountryReader();
    }

    public static AvailablePhoneNumberCountryFetcher fetcher(String pathAccountSid, String pathCountryCode) {
        return new AvailablePhoneNumberCountryFetcher(pathAccountSid, pathCountryCode);
    }

    public static AvailablePhoneNumberCountryFetcher fetcher(String pathCountryCode) {
        return new AvailablePhoneNumberCountryFetcher(pathCountryCode);
    }

    public static AvailablePhoneNumberCountry fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (AvailablePhoneNumberCountry)objectMapper.readValue(json, AvailablePhoneNumberCountry.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AvailablePhoneNumberCountry fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (AvailablePhoneNumberCountry)objectMapper.readValue(json, AvailablePhoneNumberCountry.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AvailablePhoneNumberCountry(@JsonProperty(value="country_code") String countryCode, @JsonProperty(value="country") String country, @JsonProperty(value="uri") URI uri, @JsonProperty(value="beta") Boolean beta, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris) {
        this.countryCode = countryCode;
        this.country = country;
        this.uri = uri;
        this.beta = beta;
        this.subresourceUris = subresourceUris;
    }

    public final String getCountryCode() {
        return this.countryCode;
    }

    public final String getCountry() {
        return this.country;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final Boolean getBeta() {
        return this.beta;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailablePhoneNumberCountry other = (AvailablePhoneNumberCountry)o;
        return Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.country, other.country) && Objects.equals(this.uri, other.uri) && Objects.equals(this.beta, other.beta) && Objects.equals(this.subresourceUris, other.subresourceUris);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.country, this.uri, this.beta, this.subresourceUris);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("countryCode", (Object)this.countryCode).add("country", (Object)this.country).add("uri", (Object)this.uri).add("beta", (Object)this.beta).add("subresourceUris", this.subresourceUris).toString();
    }
}

