/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.jwt.taskrouter;

import com.google.common.base.Joiner;
import com.twilio.http.HttpMethod;
import com.twilio.jwt.taskrouter.Policy;
import com.twilio.jwt.taskrouter.UrlUtils;
import java.util.ArrayList;
import java.util.List;

public class PolicyUtils {
    private static final String TASKROUTER_EVENT_URL = "https://event-bridge.twilio.com/v1/wschannels";

    private PolicyUtils() {
    }

    public static List<Policy> defaultWorkerPolicies(String workspaceSid, String workerSid) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        policies.add(new Policy.Builder().url(UrlUtils.activities(workspaceSid)).method(HttpMethod.GET).allowed(true).build());
        policies.add(new Policy.Builder().url(UrlUtils.allTasks(workspaceSid)).method(HttpMethod.GET).allowed(true).build());
        policies.add(new Policy.Builder().url(UrlUtils.allReservations(workspaceSid, workerSid)).method(HttpMethod.GET).allowed(true).build());
        policies.add(new Policy.Builder().url(UrlUtils.worker(workspaceSid, workerSid)).method(HttpMethod.GET).allowed(true).build());
        return policies;
    }

    public static List<Policy> defaultEventBridgePolicies(String accountSid, String channelId) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        String url = Joiner.on((char)'/').join((Object)TASKROUTER_EVENT_URL, (Object)accountSid, new Object[]{channelId});
        policies.add(new Policy.Builder().url(url).method(HttpMethod.GET).allowed(true).build());
        policies.add(new Policy.Builder().url(url).method(HttpMethod.POST).allowed(true).build());
        return policies;
    }
}

