/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.twilio.converter.Promoter;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SubscribeRule {
    private static final SubscribeRule subscribeAll = SubscribeRule.builder().withType(Type.INCLUDE).withAll().build();
    private static final SubscribeRule subscribeNone = SubscribeRule.builder().withType(Type.EXCLUDE).withAll().build();
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="all")
    private final Boolean all;
    @JsonProperty(value="publisher")
    private final String publisher;
    @JsonProperty(value="track")
    private final String track;
    @JsonProperty(value="kind")
    private final Kind kind;
    @JsonProperty(value="priority")
    private final Priority priority;

    public SubscribeRule(@JsonProperty(value="type") Type type, @JsonProperty(value="all") Boolean all, @JsonProperty(value="publisher") String publisher, @JsonProperty(value="track") String track, @JsonProperty(value="kind") Kind kind, @JsonProperty(value="priority") Priority priority) {
        this.type = type;
        this.all = all;
        this.publisher = publisher;
        this.track = track;
        this.kind = kind;
        this.priority = priority;
    }

    public SubscribeRule() {
        this.type = null;
        this.all = null;
        this.publisher = null;
        this.track = null;
        this.kind = null;
        this.priority = null;
    }

    public static BuilderStart builder() {
        return new Builder();
    }

    public Type getType() {
        return this.type;
    }

    public Boolean getAll() {
        return this.all;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getTrack() {
        return this.track;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public static SubscribeRule all() {
        return subscribeAll;
    }

    public static SubscribeRule none() {
        return subscribeNone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscribeRule)) {
            return false;
        }
        SubscribeRule that = (SubscribeRule)o;
        return this.getType() == that.getType() && Objects.equals(this.getAll(), that.getAll()) && Objects.equals(this.getPublisher(), that.getPublisher()) && Objects.equals(this.getTrack(), that.getTrack()) && this.getKind() == that.getKind() && this.getPriority() == that.getPriority();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getAll(), this.getPublisher(), this.getTrack(), this.getKind(), this.getPriority()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("all", (Object)this.all).add("publisher", (Object)this.publisher).add("track", (Object)this.track).add("kind", (Object)this.kind).add("priority", (Object)this.priority).toString();
    }

    public static class Builder
    implements BuilderStart,
    BuilderMiddle,
    BuilderMiddleBuild,
    BuilderBuild {
        private Type type;
        private Boolean all;
        private String publisher;
        private Kind kind;
        private String track;
        private Priority priority;

        private Builder() {
        }

        @Override
        public BuilderMiddle withType(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public BuilderBuild withAll() {
            this.all = true;
            return this;
        }

        @Override
        public BuilderMiddleBuild withPublisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        @Override
        public BuilderMiddleBuild withKind(Kind kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public BuilderMiddleBuild withTrack(String track) {
            this.track = track;
            return this;
        }

        @Override
        public BuilderMiddleBuild withPriority(Priority priority) {
            this.priority = priority;
            return this;
        }

        private boolean hasOneFilter() {
            return this.kind != null || this.all != null || this.track != null || this.publisher != null || this.priority != null;
        }

        private boolean hasType() {
            return this.type != null;
        }

        @Override
        public SubscribeRule build() {
            if (!this.hasType()) {
                throw new IllegalArgumentException("Subscribe Rule must have a type");
            }
            if (!this.hasOneFilter()) {
                throw new IllegalArgumentException("Subscribe Rule must have at least one filter");
            }
            return new SubscribeRule(this.type, this.all, this.publisher, this.track, this.kind, this.priority);
        }
    }

    public static interface BuilderBuild {
        public SubscribeRule build();
    }

    public static interface BuilderMiddleBuild {
        public BuilderMiddleBuild withPublisher(String var1);

        public BuilderMiddleBuild withKind(Kind var1);

        public BuilderMiddleBuild withTrack(String var1);

        public BuilderMiddleBuild withPriority(Priority var1);

        public SubscribeRule build();
    }

    public static interface BuilderMiddle {
        public BuilderMiddleBuild withPublisher(String var1);

        public BuilderMiddleBuild withKind(Kind var1);

        public BuilderMiddleBuild withTrack(String var1);

        public BuilderMiddleBuild withPriority(Priority var1);

        public BuilderBuild withAll();
    }

    public static interface BuilderStart {
        public BuilderMiddle withType(Type var1);
    }

    public static enum Priority {
        LOW("low"),
        STANDARD("standard"),
        HIGH("high");

        private final String value;

        private Priority(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Priority forValue(String value) {
            return (Priority)Promoter.enumFromString((String)value, (Enum[])Priority.values());
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Kind {
        AUDIO("audio"),
        DATA("data"),
        VIDEO("video");

        private final String value;

        private Kind(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Kind forValue(String value) {
            return (Kind)Promoter.enumFromString((String)value, (Enum[])Kind.values());
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Type {
        INCLUDE("include"),
        EXCLUDE("exclude");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            return (Type)Promoter.enumFromString((String)value, (Enum[])Type.values());
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

