/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.voice.v1.ByocTrunkCreator;
import com.twilio.rest.voice.v1.ByocTrunkDeleter;
import com.twilio.rest.voice.v1.ByocTrunkFetcher;
import com.twilio.rest.voice.v1.ByocTrunkReader;
import com.twilio.rest.voice.v1.ByocTrunkUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ByocTrunk
extends Resource {
    private static final long serialVersionUID = 155966179208903L;
    private final String accountSid;
    private final String sid;
    private final String friendlyName;
    private final URI voiceUrl;
    private final HttpMethod voiceMethod;
    private final URI voiceFallbackUrl;
    private final HttpMethod voiceFallbackMethod;
    private final URI statusCallbackUrl;
    private final HttpMethod statusCallbackMethod;
    private final Boolean cnamLookupEnabled;
    private final String connectionPolicySid;
    private final String fromDomainSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static ByocTrunkCreator creator() {
        return new ByocTrunkCreator();
    }

    public static ByocTrunkFetcher fetcher(String pathSid) {
        return new ByocTrunkFetcher(pathSid);
    }

    public static ByocTrunkReader reader() {
        return new ByocTrunkReader();
    }

    public static ByocTrunkUpdater updater(String pathSid) {
        return new ByocTrunkUpdater(pathSid);
    }

    public static ByocTrunkDeleter deleter(String pathSid) {
        return new ByocTrunkDeleter(pathSid);
    }

    public static ByocTrunk fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ByocTrunk)objectMapper.readValue(json, ByocTrunk.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ByocTrunk fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ByocTrunk)objectMapper.readValue(json, ByocTrunk.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ByocTrunk(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="voice_url") URI voiceUrl, @JsonProperty(value="voice_method") HttpMethod voiceMethod, @JsonProperty(value="voice_fallback_url") URI voiceFallbackUrl, @JsonProperty(value="voice_fallback_method") HttpMethod voiceFallbackMethod, @JsonProperty(value="status_callback_url") URI statusCallbackUrl, @JsonProperty(value="status_callback_method") HttpMethod statusCallbackMethod, @JsonProperty(value="cnam_lookup_enabled") Boolean cnamLookupEnabled, @JsonProperty(value="connection_policy_sid") String connectionPolicySid, @JsonProperty(value="from_domain_sid") String fromDomainSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.voiceUrl = voiceUrl;
        this.voiceMethod = voiceMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.statusCallbackUrl = statusCallbackUrl;
        this.statusCallbackMethod = statusCallbackMethod;
        this.cnamLookupEnabled = cnamLookupEnabled;
        this.connectionPolicySid = connectionPolicySid;
        this.fromDomainSid = fromDomainSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public final HttpMethod getVoiceMethod() {
        return this.voiceMethod;
    }

    public final URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    public final HttpMethod getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    public final URI getStatusCallbackUrl() {
        return this.statusCallbackUrl;
    }

    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public final Boolean getCnamLookupEnabled() {
        return this.cnamLookupEnabled;
    }

    public final String getConnectionPolicySid() {
        return this.connectionPolicySid;
    }

    public final String getFromDomainSid() {
        return this.fromDomainSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByocTrunk other = (ByocTrunk)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.voiceUrl, other.voiceUrl) && Objects.equals((Object)this.voiceMethod, (Object)other.voiceMethod) && Objects.equals(this.voiceFallbackUrl, other.voiceFallbackUrl) && Objects.equals((Object)this.voiceFallbackMethod, (Object)other.voiceFallbackMethod) && Objects.equals(this.statusCallbackUrl, other.statusCallbackUrl) && Objects.equals((Object)this.statusCallbackMethod, (Object)other.statusCallbackMethod) && Objects.equals(this.cnamLookupEnabled, other.cnamLookupEnabled) && Objects.equals(this.connectionPolicySid, other.connectionPolicySid) && Objects.equals(this.fromDomainSid, other.fromDomainSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.sid, this.friendlyName, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallbackUrl, this.statusCallbackMethod, this.cnamLookupEnabled, this.connectionPolicySid, this.fromDomainSid, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("sid", (Object)this.sid).add("friendlyName", (Object)this.friendlyName).add("voiceUrl", (Object)this.voiceUrl).add("voiceMethod", (Object)this.voiceMethod).add("voiceFallbackUrl", (Object)this.voiceFallbackUrl).add("voiceFallbackMethod", (Object)this.voiceFallbackMethod).add("statusCallbackUrl", (Object)this.statusCallbackUrl).add("statusCallbackMethod", (Object)this.statusCallbackMethod).add("cnamLookupEnabled", (Object)this.cnamLookupEnabled).add("connectionPolicySid", (Object)this.connectionPolicySid).add("fromDomainSid", (Object)this.fromDomainSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }
}

