/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.MessagingConfiguration;

public class MessagingConfigurationCreator
extends Creator<MessagingConfiguration> {
    private final String pathServiceSid;
    private final String country;
    private final String messagingServiceSid;

    public MessagingConfigurationCreator(String pathServiceSid, String country, String messagingServiceSid) {
        this.pathServiceSid = pathServiceSid;
        this.country = country;
        this.messagingServiceSid = messagingServiceSid;
    }

    @Override
    public MessagingConfiguration create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), "/v2/Services/" + this.pathServiceSid + "/MessagingConfigurations");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("MessagingConfiguration creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return MessagingConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.country != null) {
            request.addPostParam("Country", this.country);
        }
        if (this.messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", this.messagingServiceSid);
        }
    }
}

