/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.Entity;

public class EntityReader
extends Reader<Entity> {
    private final String pathServiceSid;
    private String twilioSandboxMode;

    public EntityReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public EntityReader setTwilioSandboxMode(String twilioSandboxMode) {
        this.twilioSandboxMode = twilioSandboxMode;
        return this;
    }

    @Override
    public ResourceSet<Entity> read(TwilioRestClient client) {
        return new ResourceSet<Entity>(this, client, this.firstPage(client));
    }

    private void addHeaderParams(Request request) {
        if (this.twilioSandboxMode != null) {
            request.addHeaderParam("Twilio-Sandbox-Mode", this.twilioSandboxMode);
        }
    }

    @Override
    public Page<Entity> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), "/v2/Services/" + this.pathServiceSid + "/Entities");
        this.addQueryParams(request);
        this.addHeaderParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Entity> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Entity> nextPage(Page<Entity> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Entity> previousPage(Page<Entity> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Entity> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Entity read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("entities", response.getContent(), Entity.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

