/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1.networkaccessprofile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.supersim.v1.networkaccessprofile.NetworkAccessProfileNetworkCreator;
import com.twilio.rest.supersim.v1.networkaccessprofile.NetworkAccessProfileNetworkDeleter;
import com.twilio.rest.supersim.v1.networkaccessprofile.NetworkAccessProfileNetworkFetcher;
import com.twilio.rest.supersim.v1.networkaccessprofile.NetworkAccessProfileNetworkReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NetworkAccessProfileNetwork
extends Resource {
    private static final long serialVersionUID = 26561188761279L;
    private final String sid;
    private final String networkAccessProfileSid;
    private final String friendlyName;
    private final String isoCountry;
    private final List<Map<String, Object>> identifiers;
    private final URI url;

    public static NetworkAccessProfileNetworkReader reader(String pathNetworkAccessProfileSid) {
        return new NetworkAccessProfileNetworkReader(pathNetworkAccessProfileSid);
    }

    public static NetworkAccessProfileNetworkCreator creator(String pathNetworkAccessProfileSid, String network) {
        return new NetworkAccessProfileNetworkCreator(pathNetworkAccessProfileSid, network);
    }

    public static NetworkAccessProfileNetworkDeleter deleter(String pathNetworkAccessProfileSid, String pathSid) {
        return new NetworkAccessProfileNetworkDeleter(pathNetworkAccessProfileSid, pathSid);
    }

    public static NetworkAccessProfileNetworkFetcher fetcher(String pathNetworkAccessProfileSid, String pathSid) {
        return new NetworkAccessProfileNetworkFetcher(pathNetworkAccessProfileSid, pathSid);
    }

    public static NetworkAccessProfileNetwork fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (NetworkAccessProfileNetwork)objectMapper.readValue(json, NetworkAccessProfileNetwork.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static NetworkAccessProfileNetwork fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (NetworkAccessProfileNetwork)objectMapper.readValue(json, NetworkAccessProfileNetwork.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private NetworkAccessProfileNetwork(@JsonProperty(value="sid") String sid, @JsonProperty(value="network_access_profile_sid") String networkAccessProfileSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="identifiers") List<Map<String, Object>> identifiers, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.networkAccessProfileSid = networkAccessProfileSid;
        this.friendlyName = friendlyName;
        this.isoCountry = isoCountry;
        this.identifiers = identifiers;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getNetworkAccessProfileSid() {
        return this.networkAccessProfileSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final List<Map<String, Object>> getIdentifiers() {
        return this.identifiers;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkAccessProfileNetwork other = (NetworkAccessProfileNetwork)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.networkAccessProfileSid, other.networkAccessProfileSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.identifiers, other.identifiers) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.networkAccessProfileSid, this.friendlyName, this.isoCountry, this.identifiers, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("networkAccessProfileSid", (Object)this.networkAccessProfileSid).add("friendlyName", (Object)this.friendlyName).add("isoCountry", (Object)this.isoCountry).add("identifiers", this.identifiers).add("url", (Object)this.url).toString();
    }
}

