/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.Command;

public class CommandReader
extends Reader<Command> {
    private String sim;
    private Command.Status status;
    private Command.Direction direction;

    public CommandReader setSim(String sim) {
        this.sim = sim;
        return this;
    }

    public CommandReader setStatus(Command.Status status) {
        this.status = status;
        return this;
    }

    public CommandReader setDirection(Command.Direction direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public ResourceSet<Command> read(TwilioRestClient client) {
        return new ResourceSet<Command>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Command> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), "/v1/Commands");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Command> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Command> nextPage(Page<Command> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Command> previousPage(Page<Command> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Command> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Command read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("commands", response.getContent(), Command.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.sim != null) {
            request.addQueryParam("Sim", this.sim.toString());
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.direction != null) {
            request.addQueryParam("Direction", this.direction.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

