/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.studio.v2.FlowCreator;
import com.twilio.rest.studio.v2.FlowDeleter;
import com.twilio.rest.studio.v2.FlowFetcher;
import com.twilio.rest.studio.v2.FlowReader;
import com.twilio.rest.studio.v2.FlowUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Flow
extends Resource {
    private static final long serialVersionUID = 55575307420038L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final Map<String, Object> definition;
    private final Status status;
    private final Integer revision;
    private final String commitMessage;
    private final Boolean valid;
    private final List<Map<String, Object>> errors;
    private final List<Map<String, Object>> warnings;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI webhookUrl;
    private final URI url;
    private final Map<String, String> links;

    public static FlowCreator creator(String friendlyName, Status status, Map<String, Object> definition) {
        return new FlowCreator(friendlyName, status, definition);
    }

    public static FlowUpdater updater(String pathSid, Status status) {
        return new FlowUpdater(pathSid, status);
    }

    public static FlowReader reader() {
        return new FlowReader();
    }

    public static FlowFetcher fetcher(String pathSid) {
        return new FlowFetcher(pathSid);
    }

    public static FlowDeleter deleter(String pathSid) {
        return new FlowDeleter(pathSid);
    }

    public static Flow fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Flow)objectMapper.readValue(json, Flow.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Flow fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Flow)objectMapper.readValue(json, Flow.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Flow(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="definition") Map<String, Object> definition, @JsonProperty(value="status") Status status, @JsonProperty(value="revision") Integer revision, @JsonProperty(value="commit_message") String commitMessage, @JsonProperty(value="valid") Boolean valid, @JsonProperty(value="errors") List<Map<String, Object>> errors, @JsonProperty(value="warnings") List<Map<String, Object>> warnings, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="webhook_url") URI webhookUrl, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.definition = definition;
        this.status = status;
        this.revision = revision;
        this.commitMessage = commitMessage;
        this.valid = valid;
        this.errors = errors;
        this.warnings = warnings;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.webhookUrl = webhookUrl;
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Map<String, Object> getDefinition() {
        return this.definition;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Integer getRevision() {
        return this.revision;
    }

    public final String getCommitMessage() {
        return this.commitMessage;
    }

    public final Boolean getValid() {
        return this.valid;
    }

    public final List<Map<String, Object>> getErrors() {
        return this.errors;
    }

    public final List<Map<String, Object>> getWarnings() {
        return this.warnings;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getWebhookUrl() {
        return this.webhookUrl;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Flow other = (Flow)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.definition, other.definition) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.revision, other.revision) && Objects.equals(this.commitMessage, other.commitMessage) && Objects.equals(this.valid, other.valid) && Objects.equals(this.errors, other.errors) && Objects.equals(this.warnings, other.warnings) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.webhookUrl, other.webhookUrl) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.friendlyName, this.definition, this.status, this.revision, this.commitMessage, this.valid, this.errors, this.warnings, this.dateCreated, this.dateUpdated, this.webhookUrl, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("definition", this.definition).add("status", (Object)this.status).add("revision", (Object)this.revision).add("commitMessage", (Object)this.commitMessage).add("valid", (Object)this.valid).add("errors", this.errors).add("warnings", this.warnings).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("webhookUrl", (Object)this.webhookUrl).add("url", (Object)this.url).add("links", this.links).toString();
    }

    public static enum Status {
        DRAFT("draft"),
        PUBLISHED("published");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

