/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.function.functionversion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.serverless.v1.service.function.functionversion.FunctionVersionContentFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FunctionVersionContent
extends Resource {
    private static final long serialVersionUID = 128349955760970L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String functionSid;
    private final String content;
    private final URI url;

    public static FunctionVersionContentFetcher fetcher(String pathServiceSid, String pathFunctionSid, String pathSid) {
        return new FunctionVersionContentFetcher(pathServiceSid, pathFunctionSid, pathSid);
    }

    public static FunctionVersionContent fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (FunctionVersionContent)objectMapper.readValue(json, FunctionVersionContent.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static FunctionVersionContent fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (FunctionVersionContent)objectMapper.readValue(json, FunctionVersionContent.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private FunctionVersionContent(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="function_sid") String functionSid, @JsonProperty(value="content") String content, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.functionSid = functionSid;
        this.content = content;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getFunctionSid() {
        return this.functionSid;
    }

    public final String getContent() {
        return this.content;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionVersionContent other = (FunctionVersionContent)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.functionSid, other.functionSid) && Objects.equals(this.content, other.content) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.functionSid, this.content, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("functionSid", (Object)this.functionSid).add("content", (Object)this.content).add("url", (Object)this.url).toString();
    }
}

