/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.understand.assistant.AssistantFallbackActions;

public class AssistantFallbackActionsFetcher
extends Fetcher<AssistantFallbackActions> {
    private final String pathAssistantSid;

    public AssistantFallbackActionsFetcher(String pathAssistantSid) {
        this.pathAssistantSid = pathAssistantSid;
    }

    @Override
    public AssistantFallbackActions fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/understand/Assistants/" + this.pathAssistantSid + "/FallbackActions");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AssistantFallbackActions fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return AssistantFallbackActions.fromJson(response.getStream(), client.getObjectMapper());
    }
}

