/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.document;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.document.DocumentPermission;

public class DocumentPermissionUpdater
extends Updater<DocumentPermission> {
    private final String pathServiceSid;
    private final String pathDocumentSid;
    private final String pathIdentity;
    private final Boolean read;
    private final Boolean write;
    private final Boolean manage;

    public DocumentPermissionUpdater(String pathServiceSid, String pathDocumentSid, String pathIdentity, Boolean read, Boolean write, Boolean manage) {
        this.pathServiceSid = pathServiceSid;
        this.pathDocumentSid = pathDocumentSid;
        this.pathIdentity = pathIdentity;
        this.read = read;
        this.write = write;
        this.manage = manage;
    }

    @Override
    public DocumentPermission update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/Sync/Services/" + this.pathServiceSid + "/Documents/" + this.pathDocumentSid + "/Permissions/" + this.pathIdentity + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DocumentPermission update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return DocumentPermission.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.read != null) {
            request.addPostParam("Read", this.read.toString());
        }
        if (this.write != null) {
            request.addPostParam("Write", this.write.toString());
        }
        if (this.manage != null) {
            request.addPostParam("Manage", this.manage.toString());
        }
    }
}

