/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.Service;
import java.net.URI;

public class ServiceCreator
extends Creator<Service> {
    private String friendlyName;
    private URI webhookUrl;
    private Boolean reachabilityWebhooksEnabled;
    private Boolean aclEnabled;

    public ServiceCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceCreator setWebhookUrl(URI webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    public ServiceCreator setWebhookUrl(String webhookUrl) {
        return this.setWebhookUrl(Promoter.uriFromString(webhookUrl));
    }

    public ServiceCreator setReachabilityWebhooksEnabled(Boolean reachabilityWebhooksEnabled) {
        this.reachabilityWebhooksEnabled = reachabilityWebhooksEnabled;
        return this;
    }

    public ServiceCreator setAclEnabled(Boolean aclEnabled) {
        this.aclEnabled = aclEnabled;
        return this;
    }

    @Override
    public Service create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/Sync/Services");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.webhookUrl != null) {
            request.addPostParam("WebhookUrl", this.webhookUrl.toString());
        }
        if (this.reachabilityWebhooksEnabled != null) {
            request.addPostParam("ReachabilityWebhooksEnabled", this.reachabilityWebhooksEnabled.toString());
        }
        if (this.aclEnabled != null) {
            request.addPostParam("AclEnabled", this.aclEnabled.toString());
        }
    }
}

