/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.marketplace;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.marketplace.InstalledAddOn;
import java.util.Map;

public class InstalledAddOnCreator
extends Creator<InstalledAddOn> {
    private final String availableAddOnSid;
    private final Boolean acceptTermsOfService;
    private Map<String, Object> configuration;
    private String uniqueName;

    public InstalledAddOnCreator(String availableAddOnSid, Boolean acceptTermsOfService) {
        this.availableAddOnSid = availableAddOnSid;
        this.acceptTermsOfService = acceptTermsOfService;
    }

    public InstalledAddOnCreator setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
        return this;
    }

    public InstalledAddOnCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    @Override
    public InstalledAddOn create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/marketplace/InstalledAddOns");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InstalledAddOn creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return InstalledAddOn.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.availableAddOnSid != null) {
            request.addPostParam("AvailableAddOnSid", this.availableAddOnSid);
        }
        if (this.acceptTermsOfService != null) {
            request.addPostParam("AcceptTermsOfService", this.acceptTermsOfService.toString());
        }
        if (this.configuration != null) {
            request.addPostParam("Configuration", Converter.mapToJson(this.configuration));
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
    }
}

