/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance.bundle;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.ItemAssignment;

public class ItemAssignmentDeleter
extends Deleter<ItemAssignment> {
    private final String pathBundleSid;
    private final String pathSid;

    public ItemAssignmentDeleter(String pathBundleSid, String pathSid) {
        this.pathBundleSid = pathBundleSid;
        this.pathSid = pathSid;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        Request request = new Request(HttpMethod.DELETE, Domains.NUMBERS.toString(), "/v2/RegulatoryCompliance/Bundles/" + this.pathBundleSid + "/ItemAssignments/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ItemAssignment delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return response.getStatusCode() == 204;
    }
}

