/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v2.service.Role;
import java.util.List;

public class RoleCreator
extends Creator<Role> {
    private final String pathServiceSid;
    private final String friendlyName;
    private final Role.RoleType type;
    private final List<String> permission;

    public RoleCreator(String pathServiceSid, String friendlyName, Role.RoleType type, List<String> permission) {
        this.pathServiceSid = pathServiceSid;
        this.friendlyName = friendlyName;
        this.type = type;
        this.permission = permission;
    }

    @Override
    public Role create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.IPMESSAGING.toString(), "/v2/Services/" + this.pathServiceSid + "/Roles");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Role creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Role.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
        if (this.permission != null) {
            for (String prop : this.permission) {
                request.addPostParam("Permission", prop);
            }
        }
    }
}

