/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.call;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.call.Event;

public class EventReader
extends Reader<Event> {
    private final String pathCallSid;
    private Event.TwilioEdge edge;

    public EventReader(String pathCallSid) {
        this.pathCallSid = pathCallSid;
    }

    public EventReader setEdge(Event.TwilioEdge edge) {
        this.edge = edge;
        return this;
    }

    @Override
    public ResourceSet<Event> read(TwilioRestClient client) {
        return new ResourceSet<Event>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Event> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.INSIGHTS.toString(), "/v1/Voice/" + this.pathCallSid + "/Events");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> nextPage(Page<Event> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> previousPage(Page<Event> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Event> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Event read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("events", response.getContent(), Event.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.edge != null) {
            request.addQueryParam("Edge", this.edge.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

