/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.events.v1.SchemaFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Schema
extends Resource {
    private static final long serialVersionUID = 182308016229610L;
    private final String id;
    private final URI url;
    private final Map<String, String> links;
    private final DateTime lastCreated;
    private final Integer lastVersion;

    public static SchemaFetcher fetcher(String pathId) {
        return new SchemaFetcher(pathId);
    }

    public static Schema fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Schema)objectMapper.readValue(json, Schema.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Schema fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Schema)objectMapper.readValue(json, Schema.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Schema(@JsonProperty(value="id") String id, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="last_created") String lastCreated, @JsonProperty(value="last_version") Integer lastVersion) {
        this.id = id;
        this.url = url;
        this.links = links;
        this.lastCreated = DateConverter.iso8601DateTimeFromString(lastCreated);
        this.lastVersion = lastVersion;
    }

    public final String getId() {
        return this.id;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final DateTime getLastCreated() {
        return this.lastCreated;
    }

    public final Integer getLastVersion() {
        return this.lastVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema other = (Schema)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links) && Objects.equals(this.lastCreated, other.lastCreated) && Objects.equals(this.lastVersion, other.lastVersion);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url, this.links, this.lastCreated, this.lastVersion);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("url", (Object)this.url).add("links", this.links).add("lastCreated", (Object)this.lastCreated).add("lastVersion", (Object)this.lastVersion).toString();
    }
}

