/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.configuration.WebhookFetcher;
import com.twilio.rest.conversations.v1.configuration.WebhookUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Webhook
extends Resource {
    private static final long serialVersionUID = 177976816253651L;
    private final String accountSid;
    private final Method method;
    private final List<String> filters;
    private final String preWebhookUrl;
    private final String postWebhookUrl;
    private final Target target;
    private final URI url;

    public static WebhookFetcher fetcher() {
        return new WebhookFetcher();
    }

    public static WebhookUpdater updater() {
        return new WebhookUpdater();
    }

    public static Webhook fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Webhook)objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Webhook fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Webhook)objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Webhook(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="method") Method method, @JsonProperty(value="filters") List<String> filters, @JsonProperty(value="pre_webhook_url") String preWebhookUrl, @JsonProperty(value="post_webhook_url") String postWebhookUrl, @JsonProperty(value="target") Target target, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.method = method;
        this.filters = filters;
        this.preWebhookUrl = preWebhookUrl;
        this.postWebhookUrl = postWebhookUrl;
        this.target = target;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Method getMethod() {
        return this.method;
    }

    public final List<String> getFilters() {
        return this.filters;
    }

    public final String getPreWebhookUrl() {
        return this.preWebhookUrl;
    }

    public final String getPostWebhookUrl() {
        return this.postWebhookUrl;
    }

    public final Target getTarget() {
        return this.target;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook other = (Webhook)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.method, (Object)other.method) && Objects.equals(this.filters, other.filters) && Objects.equals(this.preWebhookUrl, other.preWebhookUrl) && Objects.equals(this.postWebhookUrl, other.postWebhookUrl) && Objects.equals((Object)this.target, (Object)other.target) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.method, this.filters, this.preWebhookUrl, this.postWebhookUrl, this.target, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("method", (Object)this.method).add("filters", this.filters).add("preWebhookUrl", (Object)this.preWebhookUrl).add("postWebhookUrl", (Object)this.postWebhookUrl).add("target", (Object)this.target).add("url", (Object)this.url).toString();
    }

    public static enum Method {
        GET("GET"),
        POST("POST");

        private final String value;

        private Method(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Method forValue(String value) {
            return (Method)Promoter.enumFromString((String)value, (Enum[])Method.values());
        }
    }

    public static enum Target {
        WEBHOOK("webhook"),
        FLEX("flex");

        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Target forValue(String value) {
            return (Target)Promoter.enumFromString((String)value, (Enum[])Target.values());
        }
    }
}

