/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.bulkexports.v1.export;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.bulkexports.v1.export.Job;

public class JobFetcher
extends Fetcher<Job> {
    private final String pathJobSid;

    public JobFetcher(String pathJobSid) {
        this.pathJobSid = pathJobSid;
    }

    @Override
    public Job fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.BULKEXPORTS.toString(), "/v1/Exports/Jobs/" + this.pathJobSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Job fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Job.fromJson(response.getStream(), client.getObjectMapper());
    }
}

