/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.jwt.client;

import com.google.common.base.Joiner;
import com.twilio.jwt.Jwt;
import com.twilio.jwt.JwtEncodingException;
import com.twilio.jwt.client.Scope;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientCapability
extends Jwt {
    private final List<Scope> scopes;

    private ClientCapability(Builder b) {
        super(SignatureAlgorithm.HS256, b.authToken, b.accountSid, new Date(new Date().getTime() + (long)(b.ttl * 1000)));
        this.scopes = b.scopes;
    }

    @Override
    public Map<String, Object> getHeaders() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("alg", "HS256");
        return headers;
    }

    @Override
    public Map<String, Object> getClaims() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        try {
            ArrayList<String> scopes = new ArrayList<String>();
            for (Scope scope : this.scopes) {
                scopes.add(scope.getPayload());
            }
            payload.put("scope", Joiner.on((char)' ').join(scopes));
        }
        catch (UnsupportedEncodingException e) {
            throw new JwtEncodingException(e);
        }
        return payload;
    }

    public static class Builder {
        private String accountSid;
        private String authToken;
        private int ttl = 3600;
        private List<Scope> scopes = new ArrayList<Scope>();

        public Builder(String accountSid, String authToken) {
            this.accountSid = accountSid;
            this.authToken = authToken;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder scopes(Collection<Scope> scopes) {
            this.scopes.addAll(scopes);
            return this;
        }

        public ClientCapability build() {
            return new ClientCapability(this);
        }
    }
}

