/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.type.PhoneNumber;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class Sms
extends TwiML {
    private final PhoneNumber to;
    private final PhoneNumber from;
    private final URI action;
    private final HttpMethod method;
    private final URI statusCallback;
    private final String message;

    private Sms() {
        this(new Builder(null));
    }

    private Sms(Builder b) {
        super("Sms", b);
        this.to = b.to;
        this.from = b.from;
        this.action = b.action;
        this.method = b.method;
        this.statusCallback = b.statusCallback;
        this.message = b.message;
    }

    @Override
    protected String getElementBody() {
        return this.getMessage() == null ? null : this.getMessage();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getTo() != null) {
            attrs.put("to", this.getTo().toString());
        }
        if (this.getFrom() != null) {
            attrs.put("from", this.getFrom().toString());
        }
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        return attrs;
    }

    public PhoneNumber getTo() {
        return this.to;
    }

    public PhoneNumber getFrom() {
        return this.from;
    }

    public URI getAction() {
        return this.action;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getStatusCallback() {
        return this.statusCallback;
    }

    public String getMessage() {
        return this.message;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private PhoneNumber to;
        private PhoneNumber from;
        private URI action;
        private HttpMethod method;
        private URI statusCallback;
        private String message;

        public Builder(String message) {
            this.message = message;
        }

        public Builder to(PhoneNumber to) {
            this.to = to;
            return this;
        }

        public Builder to(String to) {
            this.to = Promoter.phoneNumberFromString(to);
            return this;
        }

        public Builder from(PhoneNumber from) {
            this.from = from;
            return this;
        }

        public Builder from(String from) {
            this.from = Promoter.phoneNumberFromString(from);
            return this;
        }

        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        public Sms build() {
            return new Sms(this);
        }
    }
}

