/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class Queue
extends TwiML {
    private final URI url;
    private final HttpMethod method;
    private final String reservationSid;
    private final String postWorkActivitySid;
    private final String name;

    private Queue() {
        this(new Builder(null));
    }

    private Queue(Builder b) {
        super("Queue", b);
        this.url = b.url;
        this.method = b.method;
        this.reservationSid = b.reservationSid;
        this.postWorkActivitySid = b.postWorkActivitySid;
        this.name = b.name;
    }

    @Override
    protected String getElementBody() {
        return this.getName() == null ? null : this.getName();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getUrl() != null) {
            attrs.put("url", this.getUrl().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getReservationSid() != null) {
            attrs.put("reservationSid", this.getReservationSid());
        }
        if (this.getPostWorkActivitySid() != null) {
            attrs.put("postWorkActivitySid", this.getPostWorkActivitySid());
        }
        return attrs;
    }

    public URI getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getReservationSid() {
        return this.reservationSid;
    }

    public String getPostWorkActivitySid() {
        return this.postWorkActivitySid;
    }

    public String getName() {
        return this.name;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI url;
        private HttpMethod method;
        private String reservationSid;
        private String postWorkActivitySid;
        private String name;

        public Builder(String name) {
            this.name = name;
        }

        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Promoter.uriFromString(url);
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder reservationSid(String reservationSid) {
            this.reservationSid = reservationSid;
            return this;
        }

        public Builder postWorkActivitySid(String postWorkActivitySid) {
            this.postWorkActivitySid = postWorkActivitySid;
            return this;
        }

        public Queue build() {
            return new Queue(this);
        }
    }
}

