/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.entity;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.entity.Factor;

public class FactorFetcher
extends Fetcher<Factor> {
    private final String pathServiceSid;
    private final String pathIdentity;
    private final String pathSid;
    private String twilioSandboxMode;

    public FactorFetcher(String pathServiceSid, String pathIdentity, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.pathSid = pathSid;
    }

    public FactorFetcher setTwilioSandboxMode(String twilioSandboxMode) {
        this.twilioSandboxMode = twilioSandboxMode;
        return this;
    }

    @Override
    public Factor fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), "/v2/Services/" + this.pathServiceSid + "/Entities/" + this.pathIdentity + "/Factors/" + this.pathSid + "");
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Factor fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Factor.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.twilioSandboxMode != null) {
            request.addHeaderParam("Twilio-Sandbox-Mode", this.twilioSandboxMode);
        }
    }
}

