/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.AccessTokenCreator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessToken
extends Resource {
    private static final long serialVersionUID = 123884033173693L;
    private final String token;

    public static AccessTokenCreator creator(String pathServiceSid, String identity, FactorTypes factorType) {
        return new AccessTokenCreator(pathServiceSid, identity, factorType);
    }

    public static AccessToken fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (AccessToken)objectMapper.readValue(json, AccessToken.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AccessToken fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (AccessToken)objectMapper.readValue(json, AccessToken.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AccessToken(@JsonProperty(value="token") String token) {
        this.token = token;
    }

    public final String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken other = (AccessToken)o;
        return Objects.equals(this.token, other.token);
    }

    public int hashCode() {
        return Objects.hash(this.token);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("token", (Object)this.token).toString();
    }

    public static enum FactorTypes {
        PUSH("push");

        private final String value;

        private FactorTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static FactorTypes forValue(String value) {
            return (FactorTypes)Promoter.enumFromString((String)value, (Enum[])FactorTypes.values());
        }
    }
}

