/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Worker;

public class WorkerCreator
extends Creator<Worker> {
    private final String pathWorkspaceSid;
    private final String friendlyName;
    private String activitySid;
    private String attributes;

    public WorkerCreator(String pathWorkspaceSid, String friendlyName) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.friendlyName = friendlyName;
    }

    public WorkerCreator setActivitySid(String activitySid) {
        this.activitySid = activitySid;
        return this;
    }

    public WorkerCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public Worker create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Workers");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Worker creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Worker.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.activitySid != null) {
            request.addPostParam("ActivitySid", this.activitySid);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
    }
}

