/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.studio.v2.flow.FlowTestUserFetcher;
import com.twilio.rest.studio.v2.flow.FlowTestUserUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FlowTestUser
extends Resource {
    private static final long serialVersionUID = 179832058834973L;
    private final String sid;
    private final List<String> testUsers;
    private final URI url;

    public static FlowTestUserFetcher fetcher(String pathSid) {
        return new FlowTestUserFetcher(pathSid);
    }

    public static FlowTestUserUpdater updater(String pathSid, List<String> testUsers) {
        return new FlowTestUserUpdater(pathSid, testUsers);
    }

    public static FlowTestUser fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (FlowTestUser)objectMapper.readValue(json, FlowTestUser.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static FlowTestUser fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (FlowTestUser)objectMapper.readValue(json, FlowTestUser.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private FlowTestUser(@JsonProperty(value="sid") String sid, @JsonProperty(value="test_users") List<String> testUsers, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.testUsers = testUsers;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final List<String> getTestUsers() {
        return this.testUsers;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowTestUser other = (FlowTestUser)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.testUsers, other.testUsers) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.testUsers, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("testUsers", this.testUsers).add("url", (Object)this.url).toString();
    }
}

