/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service.session.participant;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.service.session.participant.MessageInteraction;
import java.net.URI;
import java.util.List;

public class MessageInteractionCreator
extends Creator<MessageInteraction> {
    private final String pathServiceSid;
    private final String pathSessionSid;
    private final String pathParticipantSid;
    private String body;
    private List<URI> mediaUrl;

    public MessageInteractionCreator(String pathServiceSid, String pathSessionSid, String pathParticipantSid, String body) {
        this.pathServiceSid = pathServiceSid;
        this.pathSessionSid = pathSessionSid;
        this.pathParticipantSid = pathParticipantSid;
        this.body = body;
    }

    public MessageInteractionCreator(String pathServiceSid, String pathSessionSid, String pathParticipantSid, List<URI> mediaUrl) {
        this.pathServiceSid = pathServiceSid;
        this.pathSessionSid = pathSessionSid;
        this.pathParticipantSid = pathParticipantSid;
        this.mediaUrl = mediaUrl;
    }

    public MessageInteractionCreator setBody(String body) {
        this.body = body;
        return this;
    }

    public MessageInteractionCreator setMediaUrl(List<URI> mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    public MessageInteractionCreator setMediaUrl(URI mediaUrl) {
        return this.setMediaUrl(Promoter.listOfOne(mediaUrl));
    }

    public MessageInteractionCreator setMediaUrl(String mediaUrl) {
        return this.setMediaUrl(Promoter.uriFromString(mediaUrl));
    }

    @Override
    public MessageInteraction create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PROXY.toString(), "/v1/Services/" + this.pathServiceSid + "/Sessions/" + this.pathSessionSid + "/Participants/" + this.pathParticipantSid + "/MessageInteractions");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("MessageInteraction creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return MessageInteraction.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.body != null) {
            request.addPostParam("Body", this.body);
        }
        if (this.mediaUrl != null) {
            for (URI prop : this.mediaUrl) {
                request.addPostParam("MediaUrl", prop.toString());
            }
        }
    }
}

