/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.pricing.v2.voice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.pricing.v2.voice.NumberFetcher;
import com.twilio.type.InboundCallPrice;
import com.twilio.type.OutboundCallPriceWithOrigin;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Currency;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Number
extends Resource {
    private static final long serialVersionUID = 178498461042765L;
    private final PhoneNumber destinationNumber;
    private final PhoneNumber originationNumber;
    private final String country;
    private final String isoCountry;
    private final List<OutboundCallPriceWithOrigin> outboundCallPrices;
    private final InboundCallPrice inboundCallPrice;
    private final Currency priceUnit;
    private final URI url;

    public static NumberFetcher fetcher(PhoneNumber pathDestinationNumber) {
        return new NumberFetcher(pathDestinationNumber);
    }

    public static Number fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Number)objectMapper.readValue(json, Number.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Number fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Number)objectMapper.readValue(json, Number.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Number(@JsonProperty(value="destination_number") PhoneNumber destinationNumber, @JsonProperty(value="origination_number") PhoneNumber originationNumber, @JsonProperty(value="country") String country, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="outbound_call_prices") List<OutboundCallPriceWithOrigin> outboundCallPrices, @JsonProperty(value="inbound_call_price") InboundCallPrice inboundCallPrice, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="url") URI url) {
        this.destinationNumber = destinationNumber;
        this.originationNumber = originationNumber;
        this.country = country;
        this.isoCountry = isoCountry;
        this.outboundCallPrices = outboundCallPrices;
        this.inboundCallPrice = inboundCallPrice;
        this.priceUnit = priceUnit;
        this.url = url;
    }

    public final PhoneNumber getDestinationNumber() {
        return this.destinationNumber;
    }

    public final PhoneNumber getOriginationNumber() {
        return this.originationNumber;
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final List<OutboundCallPriceWithOrigin> getOutboundCallPrices() {
        return this.outboundCallPrices;
    }

    public final InboundCallPrice getInboundCallPrice() {
        return this.inboundCallPrice;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Number other = (Number)o;
        return Objects.equals(this.destinationNumber, other.destinationNumber) && Objects.equals(this.originationNumber, other.originationNumber) && Objects.equals(this.country, other.country) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.outboundCallPrices, other.outboundCallPrices) && Objects.equals(this.inboundCallPrice, other.inboundCallPrice) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.destinationNumber, this.originationNumber, this.country, this.isoCountry, this.outboundCallPrices, this.inboundCallPrice, this.priceUnit, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("destinationNumber", (Object)this.destinationNumber).add("originationNumber", (Object)this.originationNumber).add("country", (Object)this.country).add("isoCountry", (Object)this.isoCountry).add("outboundCallPrices", this.outboundCallPrices).add("inboundCallPrice", (Object)this.inboundCallPrice).add("priceUnit", (Object)this.priceUnit).add("url", (Object)this.url).toString();
    }
}

