/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.wireless;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.preview.wireless.SimFetcher;
import com.twilio.rest.preview.wireless.SimReader;
import com.twilio.rest.preview.wireless.SimUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Sim
extends Resource {
    private static final long serialVersionUID = 114188106016645L;
    private final String sid;
    private final String uniqueName;
    private final String accountSid;
    private final String ratePlanSid;
    private final String friendlyName;
    private final String iccid;
    private final String eId;
    private final String status;
    private final URI commandsCallbackUrl;
    private final String commandsCallbackMethod;
    private final HttpMethod smsFallbackMethod;
    private final URI smsFallbackUrl;
    private final HttpMethod smsMethod;
    private final URI smsUrl;
    private final HttpMethod voiceFallbackMethod;
    private final URI voiceFallbackUrl;
    private final HttpMethod voiceMethod;
    private final URI voiceUrl;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static SimFetcher fetcher(String pathSid) {
        return new SimFetcher(pathSid);
    }

    public static SimReader reader() {
        return new SimReader();
    }

    public static SimUpdater updater(String pathSid) {
        return new SimUpdater(pathSid);
    }

    public static Sim fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Sim)objectMapper.readValue(json, Sim.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Sim fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Sim)objectMapper.readValue(json, Sim.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Sim(@JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="rate_plan_sid") String ratePlanSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="iccid") String iccid, @JsonProperty(value="e_id") String eId, @JsonProperty(value="status") String status, @JsonProperty(value="commands_callback_url") URI commandsCallbackUrl, @JsonProperty(value="commands_callback_method") String commandsCallbackMethod, @JsonProperty(value="sms_fallback_method") HttpMethod smsFallbackMethod, @JsonProperty(value="sms_fallback_url") URI smsFallbackUrl, @JsonProperty(value="sms_method") HttpMethod smsMethod, @JsonProperty(value="sms_url") URI smsUrl, @JsonProperty(value="voice_fallback_method") HttpMethod voiceFallbackMethod, @JsonProperty(value="voice_fallback_url") URI voiceFallbackUrl, @JsonProperty(value="voice_method") HttpMethod voiceMethod, @JsonProperty(value="voice_url") URI voiceUrl, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.accountSid = accountSid;
        this.ratePlanSid = ratePlanSid;
        this.friendlyName = friendlyName;
        this.iccid = iccid;
        this.eId = eId;
        this.status = status;
        this.commandsCallbackUrl = commandsCallbackUrl;
        this.commandsCallbackMethod = commandsCallbackMethod;
        this.smsFallbackMethod = smsFallbackMethod;
        this.smsFallbackUrl = smsFallbackUrl;
        this.smsMethod = smsMethod;
        this.smsUrl = smsUrl;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceMethod = voiceMethod;
        this.voiceUrl = voiceUrl;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getRatePlanSid() {
        return this.ratePlanSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getIccid() {
        return this.iccid;
    }

    public final String getEId() {
        return this.eId;
    }

    public final String getStatus() {
        return this.status;
    }

    public final URI getCommandsCallbackUrl() {
        return this.commandsCallbackUrl;
    }

    public final String getCommandsCallbackMethod() {
        return this.commandsCallbackMethod;
    }

    public final HttpMethod getSmsFallbackMethod() {
        return this.smsFallbackMethod;
    }

    public final URI getSmsFallbackUrl() {
        return this.smsFallbackUrl;
    }

    public final HttpMethod getSmsMethod() {
        return this.smsMethod;
    }

    public final URI getSmsUrl() {
        return this.smsUrl;
    }

    public final HttpMethod getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    public final URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    public final HttpMethod getVoiceMethod() {
        return this.voiceMethod;
    }

    public final URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sim other = (Sim)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.ratePlanSid, other.ratePlanSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.iccid, other.iccid) && Objects.equals(this.eId, other.eId) && Objects.equals(this.status, other.status) && Objects.equals(this.commandsCallbackUrl, other.commandsCallbackUrl) && Objects.equals(this.commandsCallbackMethod, other.commandsCallbackMethod) && Objects.equals((Object)this.smsFallbackMethod, (Object)other.smsFallbackMethod) && Objects.equals(this.smsFallbackUrl, other.smsFallbackUrl) && Objects.equals((Object)this.smsMethod, (Object)other.smsMethod) && Objects.equals(this.smsUrl, other.smsUrl) && Objects.equals((Object)this.voiceFallbackMethod, (Object)other.voiceFallbackMethod) && Objects.equals(this.voiceFallbackUrl, other.voiceFallbackUrl) && Objects.equals((Object)this.voiceMethod, (Object)other.voiceMethod) && Objects.equals(this.voiceUrl, other.voiceUrl) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.uniqueName, this.accountSid, this.ratePlanSid, this.friendlyName, this.iccid, this.eId, this.status, this.commandsCallbackUrl, this.commandsCallbackMethod, this.smsFallbackMethod, this.smsFallbackUrl, this.smsMethod, this.smsUrl, this.voiceFallbackMethod, this.voiceFallbackUrl, this.voiceMethod, this.voiceUrl, this.dateCreated, this.dateUpdated, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("uniqueName", (Object)this.uniqueName).add("accountSid", (Object)this.accountSid).add("ratePlanSid", (Object)this.ratePlanSid).add("friendlyName", (Object)this.friendlyName).add("iccid", (Object)this.iccid).add("eId", (Object)this.eId).add("status", (Object)this.status).add("commandsCallbackUrl", (Object)this.commandsCallbackUrl).add("commandsCallbackMethod", (Object)this.commandsCallbackMethod).add("smsFallbackMethod", (Object)this.smsFallbackMethod).add("smsFallbackUrl", (Object)this.smsFallbackUrl).add("smsMethod", (Object)this.smsMethod).add("smsUrl", (Object)this.smsUrl).add("voiceFallbackMethod", (Object)this.voiceFallbackMethod).add("voiceFallbackUrl", (Object)this.voiceFallbackUrl).add("voiceMethod", (Object)this.voiceMethod).add("voiceUrl", (Object)this.voiceUrl).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).add("links", this.links).toString();
    }
}

