/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant.task;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.understand.assistant.task.Sample;

public class SampleCreator
extends Creator<Sample> {
    private final String pathAssistantSid;
    private final String pathTaskSid;
    private final String language;
    private final String taggedText;
    private String sourceChannel;

    public SampleCreator(String pathAssistantSid, String pathTaskSid, String language, String taggedText) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathTaskSid = pathTaskSid;
        this.language = language;
        this.taggedText = taggedText;
    }

    public SampleCreator setSourceChannel(String sourceChannel) {
        this.sourceChannel = sourceChannel;
        return this;
    }

    @Override
    public Sample create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/understand/Assistants/" + this.pathAssistantSid + "/Tasks/" + this.pathTaskSid + "/Samples");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Sample creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Sample.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.language != null) {
            request.addPostParam("Language", this.language);
        }
        if (this.taggedText != null) {
            request.addPostParam("TaggedText", this.taggedText);
        }
        if (this.sourceChannel != null) {
            request.addPostParam("SourceChannel", this.sourceChannel);
        }
    }
}

