/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.understand.assistant.Query;

public class QueryCreator
extends Creator<Query> {
    private final String pathAssistantSid;
    private final String language;
    private final String query;
    private String tasks;
    private String modelBuild;
    private String field;

    public QueryCreator(String pathAssistantSid, String language, String query) {
        this.pathAssistantSid = pathAssistantSid;
        this.language = language;
        this.query = query;
    }

    public QueryCreator setTasks(String tasks) {
        this.tasks = tasks;
        return this;
    }

    public QueryCreator setModelBuild(String modelBuild) {
        this.modelBuild = modelBuild;
        return this;
    }

    public QueryCreator setField(String field) {
        this.field = field;
        return this;
    }

    @Override
    public Query create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/understand/Assistants/" + this.pathAssistantSid + "/Queries");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Query creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Query.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.language != null) {
            request.addPostParam("Language", this.language);
        }
        if (this.query != null) {
            request.addPostParam("Query", this.query);
        }
        if (this.tasks != null) {
            request.addPostParam("Tasks", this.tasks);
        }
        if (this.modelBuild != null) {
            request.addPostParam("ModelBuild", this.modelBuild.toString());
        }
        if (this.field != null) {
            request.addPostParam("Field", this.field);
        }
    }
}

