/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.trustedComms.CurrentCall;

public class CurrentCallFetcher
extends Fetcher<CurrentCall> {
    private String xXcnamSensitivePhoneNumberFrom;
    private String xXcnamSensitivePhoneNumberTo;

    public CurrentCallFetcher setXXcnamSensitivePhoneNumberFrom(String xXcnamSensitivePhoneNumberFrom) {
        this.xXcnamSensitivePhoneNumberFrom = xXcnamSensitivePhoneNumberFrom;
        return this;
    }

    public CurrentCallFetcher setXXcnamSensitivePhoneNumberTo(String xXcnamSensitivePhoneNumberTo) {
        this.xXcnamSensitivePhoneNumberTo = xXcnamSensitivePhoneNumberTo;
        return this;
    }

    @Override
    public CurrentCall fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/TrustedComms/CurrentCall");
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CurrentCall fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return CurrentCall.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.xXcnamSensitivePhoneNumberFrom != null) {
            request.addHeaderParam("X-Xcnam-Sensitive-Phone-Number-From", this.xXcnamSensitivePhoneNumberFrom);
        }
        if (this.xXcnamSensitivePhoneNumberTo != null) {
            request.addHeaderParam("X-Xcnam-Sensitive-Phone-Number-To", this.xXcnamSensitivePhoneNumberTo);
        }
    }
}

