/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.CurrentCallFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CurrentCall
extends Resource {
    private static final long serialVersionUID = 212286172550611L;
    private final String bgColor;
    private final String caller;
    private final DateTime createdAt;
    private final String fontColor;
    private final String from;
    private final String logo;
    private final String manager;
    private final String reason;
    private final String shieldImg;
    private final String sid;
    private final String status;
    private final String to;
    private final URI url;
    private final String useCase;

    public static CurrentCallFetcher fetcher() {
        return new CurrentCallFetcher();
    }

    public static CurrentCall fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (CurrentCall)objectMapper.readValue(json, CurrentCall.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static CurrentCall fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (CurrentCall)objectMapper.readValue(json, CurrentCall.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private CurrentCall(@JsonProperty(value="bg_color") String bgColor, @JsonProperty(value="caller") String caller, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="font_color") String fontColor, @JsonProperty(value="from") String from, @JsonProperty(value="logo") String logo, @JsonProperty(value="manager") String manager, @JsonProperty(value="reason") String reason, @JsonProperty(value="shield_img") String shieldImg, @JsonProperty(value="sid") String sid, @JsonProperty(value="status") String status, @JsonProperty(value="to") String to, @JsonProperty(value="url") URI url, @JsonProperty(value="use_case") String useCase) {
        this.bgColor = bgColor;
        this.caller = caller;
        this.createdAt = DateConverter.iso8601DateTimeFromString(createdAt);
        this.fontColor = fontColor;
        this.from = from;
        this.logo = logo;
        this.manager = manager;
        this.reason = reason;
        this.shieldImg = shieldImg;
        this.sid = sid;
        this.status = status;
        this.to = to;
        this.url = url;
        this.useCase = useCase;
    }

    public final String getBgColor() {
        return this.bgColor;
    }

    public final String getCaller() {
        return this.caller;
    }

    public final DateTime getCreatedAt() {
        return this.createdAt;
    }

    public final String getFontColor() {
        return this.fontColor;
    }

    public final String getFrom() {
        return this.from;
    }

    public final String getLogo() {
        return this.logo;
    }

    public final String getManager() {
        return this.manager;
    }

    public final String getReason() {
        return this.reason;
    }

    public final String getShieldImg() {
        return this.shieldImg;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getStatus() {
        return this.status;
    }

    public final String getTo() {
        return this.to;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getUseCase() {
        return this.useCase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentCall other = (CurrentCall)o;
        return Objects.equals(this.bgColor, other.bgColor) && Objects.equals(this.caller, other.caller) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.fontColor, other.fontColor) && Objects.equals(this.from, other.from) && Objects.equals(this.logo, other.logo) && Objects.equals(this.manager, other.manager) && Objects.equals(this.reason, other.reason) && Objects.equals(this.shieldImg, other.shieldImg) && Objects.equals(this.sid, other.sid) && Objects.equals(this.status, other.status) && Objects.equals(this.to, other.to) && Objects.equals(this.url, other.url) && Objects.equals(this.useCase, other.useCase);
    }

    public int hashCode() {
        return Objects.hash(this.bgColor, this.caller, this.createdAt, this.fontColor, this.from, this.logo, this.manager, this.reason, this.shieldImg, this.sid, this.status, this.to, this.url, this.useCase);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bgColor", (Object)this.bgColor).add("caller", (Object)this.caller).add("createdAt", (Object)this.createdAt).add("fontColor", (Object)this.fontColor).add("from", (Object)this.from).add("logo", (Object)this.logo).add("manager", (Object)this.manager).add("reason", (Object)this.reason).add("shieldImg", (Object)this.shieldImg).add("sid", (Object)this.sid).add("status", (Object)this.status).add("to", (Object)this.to).add("url", (Object)this.url).add("useCase", (Object)this.useCase).toString();
    }
}

