/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.syncmap;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.syncmap.SyncMapPermission;

public class SyncMapPermissionFetcher
extends Fetcher<SyncMapPermission> {
    private final String pathServiceSid;
    private final String pathMapSid;
    private final String pathIdentity;

    public SyncMapPermissionFetcher(String pathServiceSid, String pathMapSid, String pathIdentity) {
        this.pathServiceSid = pathServiceSid;
        this.pathMapSid = pathMapSid;
        this.pathIdentity = pathIdentity;
    }

    @Override
    public SyncMapPermission fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/Sync/Services/" + this.pathServiceSid + "/Maps/" + this.pathMapSid + "/Permissions/" + this.pathIdentity + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncMapPermission fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return SyncMapPermission.fromJson(response.getStream(), client.getObjectMapper());
    }
}

