/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.deployedDevices.fleet.Deployment;

public class DeploymentFetcher
extends Fetcher<Deployment> {
    private final String pathFleetSid;
    private final String pathSid;

    public DeploymentFetcher(String pathFleetSid, String pathSid) {
        this.pathFleetSid = pathFleetSid;
        this.pathSid = pathSid;
    }

    @Override
    public Deployment fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/DeployedDevices/Fleets/" + this.pathFleetSid + "/Deployments/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Deployment fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Deployment.fromJson(response.getStream(), client.getObjectMapper());
    }
}

