/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.Bundle;

public class BundleFetcher
extends Fetcher<Bundle> {
    private final String pathSid;

    public BundleFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public Bundle fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), "/v2/RegulatoryCompliance/Bundles/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Bundle fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Bundle.fromJson(response.getStream(), client.getObjectMapper());
    }
}

