/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.conversation;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.conversation.Webhook;
import java.util.List;

public class WebhookUpdater
extends Updater<Webhook> {
    private final String pathChatServiceSid;
    private final String pathConversationSid;
    private final String pathSid;
    private String configurationUrl;
    private Webhook.Method configurationMethod;
    private List<String> configurationFilters;
    private List<String> configurationTriggers;
    private String configurationFlowSid;

    public WebhookUpdater(String pathChatServiceSid, String pathConversationSid, String pathSid) {
        this.pathChatServiceSid = pathChatServiceSid;
        this.pathConversationSid = pathConversationSid;
        this.pathSid = pathSid;
    }

    public WebhookUpdater setConfigurationUrl(String configurationUrl) {
        this.configurationUrl = configurationUrl;
        return this;
    }

    public WebhookUpdater setConfigurationMethod(Webhook.Method configurationMethod) {
        this.configurationMethod = configurationMethod;
        return this;
    }

    public WebhookUpdater setConfigurationFilters(List<String> configurationFilters) {
        this.configurationFilters = configurationFilters;
        return this;
    }

    public WebhookUpdater setConfigurationFilters(String configurationFilters) {
        return this.setConfigurationFilters(Promoter.listOfOne(configurationFilters));
    }

    public WebhookUpdater setConfigurationTriggers(List<String> configurationTriggers) {
        this.configurationTriggers = configurationTriggers;
        return this;
    }

    public WebhookUpdater setConfigurationTriggers(String configurationTriggers) {
        return this.setConfigurationTriggers(Promoter.listOfOne(configurationTriggers));
    }

    public WebhookUpdater setConfigurationFlowSid(String configurationFlowSid) {
        this.configurationFlowSid = configurationFlowSid;
        return this;
    }

    @Override
    public Webhook update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), "/v1/Services/" + this.pathChatServiceSid + "/Conversations/" + this.pathConversationSid + "/Webhooks/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Webhook update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.configurationUrl != null) {
            request.addPostParam("Configuration.Url", this.configurationUrl);
        }
        if (this.configurationMethod != null) {
            request.addPostParam("Configuration.Method", this.configurationMethod.toString());
        }
        if (this.configurationFilters != null) {
            for (String prop : this.configurationFilters) {
                request.addPostParam("Configuration.Filters", prop);
            }
        }
        if (this.configurationTriggers != null) {
            for (String prop : this.configurationTriggers) {
                request.addPostParam("Configuration.Triggers", prop);
            }
        }
        if (this.configurationFlowSid != null) {
            request.addPostParam("Configuration.FlowSid", this.configurationFlowSid);
        }
    }
}

