/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.conversation.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.conversation.message.DeliveryReceiptFetcher;
import com.twilio.rest.conversations.v1.conversation.message.DeliveryReceiptReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeliveryReceipt
extends Resource {
    private static final long serialVersionUID = 77906133631055L;
    private final String accountSid;
    private final String conversationSid;
    private final String sid;
    private final String messageSid;
    private final String channelMessageSid;
    private final String participantSid;
    private final DeliveryStatus status;
    private final Integer errorCode;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static DeliveryReceiptFetcher fetcher(String pathConversationSid, String pathMessageSid, String pathSid) {
        return new DeliveryReceiptFetcher(pathConversationSid, pathMessageSid, pathSid);
    }

    public static DeliveryReceiptReader reader(String pathConversationSid, String pathMessageSid) {
        return new DeliveryReceiptReader(pathConversationSid, pathMessageSid);
    }

    public static DeliveryReceipt fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (DeliveryReceipt)objectMapper.readValue(json, DeliveryReceipt.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static DeliveryReceipt fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (DeliveryReceipt)objectMapper.readValue(json, DeliveryReceipt.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private DeliveryReceipt(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="conversation_sid") String conversationSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="message_sid") String messageSid, @JsonProperty(value="channel_message_sid") String channelMessageSid, @JsonProperty(value="participant_sid") String participantSid, @JsonProperty(value="status") DeliveryStatus status, @JsonProperty(value="error_code") Integer errorCode, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.conversationSid = conversationSid;
        this.sid = sid;
        this.messageSid = messageSid;
        this.channelMessageSid = channelMessageSid;
        this.participantSid = participantSid;
        this.status = status;
        this.errorCode = errorCode;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getConversationSid() {
        return this.conversationSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getMessageSid() {
        return this.messageSid;
    }

    public final String getChannelMessageSid() {
        return this.channelMessageSid;
    }

    public final String getParticipantSid() {
        return this.participantSid;
    }

    public final DeliveryStatus getStatus() {
        return this.status;
    }

    public final Integer getErrorCode() {
        return this.errorCode;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryReceipt other = (DeliveryReceipt)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.conversationSid, other.conversationSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.messageSid, other.messageSid) && Objects.equals(this.channelMessageSid, other.channelMessageSid) && Objects.equals(this.participantSid, other.participantSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.conversationSid, this.sid, this.messageSid, this.channelMessageSid, this.participantSid, this.status, this.errorCode, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("conversationSid", (Object)this.conversationSid).add("sid", (Object)this.sid).add("messageSid", (Object)this.messageSid).add("channelMessageSid", (Object)this.channelMessageSid).add("participantSid", (Object)this.participantSid).add("status", (Object)this.status).add("errorCode", (Object)this.errorCode).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }

    public static enum DeliveryStatus {
        READ("read"),
        FAILED("failed"),
        DELIVERED("delivered"),
        UNDELIVERED("undelivered"),
        SENT("sent");

        private final String value;

        private DeliveryStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static DeliveryStatus forValue(String value) {
            return (DeliveryStatus)Promoter.enumFromString((String)value, (Enum[])DeliveryStatus.values());
        }
    }
}

