/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.conversation;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.conversation.Message;
import org.joda.time.DateTime;

public class MessageUpdater
extends Updater<Message> {
    private final String pathConversationSid;
    private final String pathSid;
    private String author;
    private String body;
    private DateTime dateCreated;
    private DateTime dateUpdated;
    private String attributes;
    private Message.WebhookEnabledType xTwilioWebhookEnabled;

    public MessageUpdater(String pathConversationSid, String pathSid) {
        this.pathConversationSid = pathConversationSid;
        this.pathSid = pathSid;
    }

    public MessageUpdater setAuthor(String author) {
        this.author = author;
        return this;
    }

    public MessageUpdater setBody(String body) {
        this.body = body;
        return this;
    }

    public MessageUpdater setDateCreated(DateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public MessageUpdater setDateUpdated(DateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public MessageUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public MessageUpdater setXTwilioWebhookEnabled(Message.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    @Override
    public Message update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), "/v1/Conversations/" + this.pathConversationSid + "/Messages/" + this.pathSid + "");
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Message update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Message.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }

    private void addPostParams(Request request) {
        if (this.author != null) {
            request.addPostParam("Author", this.author);
        }
        if (this.body != null) {
            request.addPostParam("Body", this.body);
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toString());
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
    }
}

