/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v2.Service;
import java.net.URI;
import java.util.List;

public class ServiceUpdater
extends Updater<Service> {
    private final String pathSid;
    private String friendlyName;
    private String defaultServiceRoleSid;
    private String defaultChannelRoleSid;
    private String defaultChannelCreatorRoleSid;
    private Boolean readStatusEnabled;
    private Boolean reachabilityEnabled;
    private Integer typingIndicatorTimeout;
    private Integer consumptionReportInterval;
    private Boolean notificationsNewMessageEnabled;
    private String notificationsNewMessageTemplate;
    private String notificationsNewMessageSound;
    private Boolean notificationsNewMessageBadgeCountEnabled;
    private Boolean notificationsAddedToChannelEnabled;
    private String notificationsAddedToChannelTemplate;
    private String notificationsAddedToChannelSound;
    private Boolean notificationsRemovedFromChannelEnabled;
    private String notificationsRemovedFromChannelTemplate;
    private String notificationsRemovedFromChannelSound;
    private Boolean notificationsInvitedToChannelEnabled;
    private String notificationsInvitedToChannelTemplate;
    private String notificationsInvitedToChannelSound;
    private URI preWebhookUrl;
    private URI postWebhookUrl;
    private HttpMethod webhookMethod;
    private List<String> webhookFilters;
    private Integer limitsChannelMembers;
    private Integer limitsUserChannels;
    private String mediaCompatibilityMessage;
    private Integer preWebhookRetryCount;
    private Integer postWebhookRetryCount;
    private Boolean notificationsLogEnabled;

    public ServiceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ServiceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceUpdater setDefaultServiceRoleSid(String defaultServiceRoleSid) {
        this.defaultServiceRoleSid = defaultServiceRoleSid;
        return this;
    }

    public ServiceUpdater setDefaultChannelRoleSid(String defaultChannelRoleSid) {
        this.defaultChannelRoleSid = defaultChannelRoleSid;
        return this;
    }

    public ServiceUpdater setDefaultChannelCreatorRoleSid(String defaultChannelCreatorRoleSid) {
        this.defaultChannelCreatorRoleSid = defaultChannelCreatorRoleSid;
        return this;
    }

    public ServiceUpdater setReadStatusEnabled(Boolean readStatusEnabled) {
        this.readStatusEnabled = readStatusEnabled;
        return this;
    }

    public ServiceUpdater setReachabilityEnabled(Boolean reachabilityEnabled) {
        this.reachabilityEnabled = reachabilityEnabled;
        return this;
    }

    public ServiceUpdater setTypingIndicatorTimeout(Integer typingIndicatorTimeout) {
        this.typingIndicatorTimeout = typingIndicatorTimeout;
        return this;
    }

    public ServiceUpdater setConsumptionReportInterval(Integer consumptionReportInterval) {
        this.consumptionReportInterval = consumptionReportInterval;
        return this;
    }

    public ServiceUpdater setNotificationsNewMessageEnabled(Boolean notificationsNewMessageEnabled) {
        this.notificationsNewMessageEnabled = notificationsNewMessageEnabled;
        return this;
    }

    public ServiceUpdater setNotificationsNewMessageTemplate(String notificationsNewMessageTemplate) {
        this.notificationsNewMessageTemplate = notificationsNewMessageTemplate;
        return this;
    }

    public ServiceUpdater setNotificationsNewMessageSound(String notificationsNewMessageSound) {
        this.notificationsNewMessageSound = notificationsNewMessageSound;
        return this;
    }

    public ServiceUpdater setNotificationsNewMessageBadgeCountEnabled(Boolean notificationsNewMessageBadgeCountEnabled) {
        this.notificationsNewMessageBadgeCountEnabled = notificationsNewMessageBadgeCountEnabled;
        return this;
    }

    public ServiceUpdater setNotificationsAddedToChannelEnabled(Boolean notificationsAddedToChannelEnabled) {
        this.notificationsAddedToChannelEnabled = notificationsAddedToChannelEnabled;
        return this;
    }

    public ServiceUpdater setNotificationsAddedToChannelTemplate(String notificationsAddedToChannelTemplate) {
        this.notificationsAddedToChannelTemplate = notificationsAddedToChannelTemplate;
        return this;
    }

    public ServiceUpdater setNotificationsAddedToChannelSound(String notificationsAddedToChannelSound) {
        this.notificationsAddedToChannelSound = notificationsAddedToChannelSound;
        return this;
    }

    public ServiceUpdater setNotificationsRemovedFromChannelEnabled(Boolean notificationsRemovedFromChannelEnabled) {
        this.notificationsRemovedFromChannelEnabled = notificationsRemovedFromChannelEnabled;
        return this;
    }

    public ServiceUpdater setNotificationsRemovedFromChannelTemplate(String notificationsRemovedFromChannelTemplate) {
        this.notificationsRemovedFromChannelTemplate = notificationsRemovedFromChannelTemplate;
        return this;
    }

    public ServiceUpdater setNotificationsRemovedFromChannelSound(String notificationsRemovedFromChannelSound) {
        this.notificationsRemovedFromChannelSound = notificationsRemovedFromChannelSound;
        return this;
    }

    public ServiceUpdater setNotificationsInvitedToChannelEnabled(Boolean notificationsInvitedToChannelEnabled) {
        this.notificationsInvitedToChannelEnabled = notificationsInvitedToChannelEnabled;
        return this;
    }

    public ServiceUpdater setNotificationsInvitedToChannelTemplate(String notificationsInvitedToChannelTemplate) {
        this.notificationsInvitedToChannelTemplate = notificationsInvitedToChannelTemplate;
        return this;
    }

    public ServiceUpdater setNotificationsInvitedToChannelSound(String notificationsInvitedToChannelSound) {
        this.notificationsInvitedToChannelSound = notificationsInvitedToChannelSound;
        return this;
    }

    public ServiceUpdater setPreWebhookUrl(URI preWebhookUrl) {
        this.preWebhookUrl = preWebhookUrl;
        return this;
    }

    public ServiceUpdater setPreWebhookUrl(String preWebhookUrl) {
        return this.setPreWebhookUrl(Promoter.uriFromString(preWebhookUrl));
    }

    public ServiceUpdater setPostWebhookUrl(URI postWebhookUrl) {
        this.postWebhookUrl = postWebhookUrl;
        return this;
    }

    public ServiceUpdater setPostWebhookUrl(String postWebhookUrl) {
        return this.setPostWebhookUrl(Promoter.uriFromString(postWebhookUrl));
    }

    public ServiceUpdater setWebhookMethod(HttpMethod webhookMethod) {
        this.webhookMethod = webhookMethod;
        return this;
    }

    public ServiceUpdater setWebhookFilters(List<String> webhookFilters) {
        this.webhookFilters = webhookFilters;
        return this;
    }

    public ServiceUpdater setWebhookFilters(String webhookFilters) {
        return this.setWebhookFilters(Promoter.listOfOne(webhookFilters));
    }

    public ServiceUpdater setLimitsChannelMembers(Integer limitsChannelMembers) {
        this.limitsChannelMembers = limitsChannelMembers;
        return this;
    }

    public ServiceUpdater setLimitsUserChannels(Integer limitsUserChannels) {
        this.limitsUserChannels = limitsUserChannels;
        return this;
    }

    public ServiceUpdater setMediaCompatibilityMessage(String mediaCompatibilityMessage) {
        this.mediaCompatibilityMessage = mediaCompatibilityMessage;
        return this;
    }

    public ServiceUpdater setPreWebhookRetryCount(Integer preWebhookRetryCount) {
        this.preWebhookRetryCount = preWebhookRetryCount;
        return this;
    }

    public ServiceUpdater setPostWebhookRetryCount(Integer postWebhookRetryCount) {
        this.postWebhookRetryCount = postWebhookRetryCount;
        return this;
    }

    public ServiceUpdater setNotificationsLogEnabled(Boolean notificationsLogEnabled) {
        this.notificationsLogEnabled = notificationsLogEnabled;
        return this;
    }

    @Override
    public Service update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CHAT.toString(), "/v2/Services/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.defaultServiceRoleSid != null) {
            request.addPostParam("DefaultServiceRoleSid", this.defaultServiceRoleSid);
        }
        if (this.defaultChannelRoleSid != null) {
            request.addPostParam("DefaultChannelRoleSid", this.defaultChannelRoleSid);
        }
        if (this.defaultChannelCreatorRoleSid != null) {
            request.addPostParam("DefaultChannelCreatorRoleSid", this.defaultChannelCreatorRoleSid);
        }
        if (this.readStatusEnabled != null) {
            request.addPostParam("ReadStatusEnabled", this.readStatusEnabled.toString());
        }
        if (this.reachabilityEnabled != null) {
            request.addPostParam("ReachabilityEnabled", this.reachabilityEnabled.toString());
        }
        if (this.typingIndicatorTimeout != null) {
            request.addPostParam("TypingIndicatorTimeout", this.typingIndicatorTimeout.toString());
        }
        if (this.consumptionReportInterval != null) {
            request.addPostParam("ConsumptionReportInterval", this.consumptionReportInterval.toString());
        }
        if (this.notificationsNewMessageEnabled != null) {
            request.addPostParam("Notifications.NewMessage.Enabled", this.notificationsNewMessageEnabled.toString());
        }
        if (this.notificationsNewMessageTemplate != null) {
            request.addPostParam("Notifications.NewMessage.Template", this.notificationsNewMessageTemplate);
        }
        if (this.notificationsNewMessageSound != null) {
            request.addPostParam("Notifications.NewMessage.Sound", this.notificationsNewMessageSound);
        }
        if (this.notificationsNewMessageBadgeCountEnabled != null) {
            request.addPostParam("Notifications.NewMessage.BadgeCountEnabled", this.notificationsNewMessageBadgeCountEnabled.toString());
        }
        if (this.notificationsAddedToChannelEnabled != null) {
            request.addPostParam("Notifications.AddedToChannel.Enabled", this.notificationsAddedToChannelEnabled.toString());
        }
        if (this.notificationsAddedToChannelTemplate != null) {
            request.addPostParam("Notifications.AddedToChannel.Template", this.notificationsAddedToChannelTemplate);
        }
        if (this.notificationsAddedToChannelSound != null) {
            request.addPostParam("Notifications.AddedToChannel.Sound", this.notificationsAddedToChannelSound);
        }
        if (this.notificationsRemovedFromChannelEnabled != null) {
            request.addPostParam("Notifications.RemovedFromChannel.Enabled", this.notificationsRemovedFromChannelEnabled.toString());
        }
        if (this.notificationsRemovedFromChannelTemplate != null) {
            request.addPostParam("Notifications.RemovedFromChannel.Template", this.notificationsRemovedFromChannelTemplate);
        }
        if (this.notificationsRemovedFromChannelSound != null) {
            request.addPostParam("Notifications.RemovedFromChannel.Sound", this.notificationsRemovedFromChannelSound);
        }
        if (this.notificationsInvitedToChannelEnabled != null) {
            request.addPostParam("Notifications.InvitedToChannel.Enabled", this.notificationsInvitedToChannelEnabled.toString());
        }
        if (this.notificationsInvitedToChannelTemplate != null) {
            request.addPostParam("Notifications.InvitedToChannel.Template", this.notificationsInvitedToChannelTemplate);
        }
        if (this.notificationsInvitedToChannelSound != null) {
            request.addPostParam("Notifications.InvitedToChannel.Sound", this.notificationsInvitedToChannelSound);
        }
        if (this.preWebhookUrl != null) {
            request.addPostParam("PreWebhookUrl", this.preWebhookUrl.toString());
        }
        if (this.postWebhookUrl != null) {
            request.addPostParam("PostWebhookUrl", this.postWebhookUrl.toString());
        }
        if (this.webhookMethod != null) {
            request.addPostParam("WebhookMethod", this.webhookMethod.toString());
        }
        if (this.webhookFilters != null) {
            for (String prop : this.webhookFilters) {
                request.addPostParam("WebhookFilters", prop);
            }
        }
        if (this.limitsChannelMembers != null) {
            request.addPostParam("Limits.ChannelMembers", this.limitsChannelMembers.toString());
        }
        if (this.limitsUserChannels != null) {
            request.addPostParam("Limits.UserChannels", this.limitsUserChannels.toString());
        }
        if (this.mediaCompatibilityMessage != null) {
            request.addPostParam("Media.CompatibilityMessage", this.mediaCompatibilityMessage);
        }
        if (this.preWebhookRetryCount != null) {
            request.addPostParam("PreWebhookRetryCount", this.preWebhookRetryCount.toString());
        }
        if (this.postWebhookRetryCount != null) {
            request.addPostParam("PostWebhookRetryCount", this.postWebhookRetryCount.toString());
        }
        if (this.notificationsLogEnabled != null) {
            request.addPostParam("Notifications.LogEnabled", this.notificationsLogEnabled.toString());
        }
    }
}

