/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.bulkexports.v1;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.bulkexports.v1.ExportConfiguration;
import java.net.URI;

public class ExportConfigurationUpdater
extends Updater<ExportConfiguration> {
    private final String pathResourceType;
    private Boolean enabled;
    private URI webhookUrl;
    private String webhookMethod;

    public ExportConfigurationUpdater(String pathResourceType) {
        this.pathResourceType = pathResourceType;
    }

    public ExportConfigurationUpdater setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ExportConfigurationUpdater setWebhookUrl(URI webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    public ExportConfigurationUpdater setWebhookUrl(String webhookUrl) {
        return this.setWebhookUrl(Promoter.uriFromString(webhookUrl));
    }

    public ExportConfigurationUpdater setWebhookMethod(String webhookMethod) {
        this.webhookMethod = webhookMethod;
        return this;
    }

    @Override
    public ExportConfiguration update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.BULKEXPORTS.toString(), "/v1/Exports/" + this.pathResourceType + "/Configuration");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ExportConfiguration update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return ExportConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.enabled != null) {
            request.addPostParam("Enabled", this.enabled.toString());
        }
        if (this.webhookUrl != null) {
            request.addPostParam("WebhookUrl", this.webhookUrl.toString());
        }
        if (this.webhookMethod != null) {
            request.addPostParam("WebhookMethod", this.webhookMethod);
        }
    }
}

