/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.RestoreAssistant;

public class RestoreAssistantUpdater
extends Updater<RestoreAssistant> {
    private final String assistant;

    public RestoreAssistantUpdater(String assistant) {
        this.assistant = assistant;
    }

    @Override
    public RestoreAssistant update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTOPILOT.toString(), "/v1/Assistants/Restore");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RestoreAssistant update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return RestoreAssistant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.assistant != null) {
            request.addPostParam("Assistant", this.assistant.toString());
        }
    }
}

