/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressCreator;
import com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressDeleter;
import com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressFetcher;
import com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressReader;
import com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IpAddress
extends Resource {
    private static final long serialVersionUID = 129871129530105L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final String ipAddress;
    private final Integer cidrPrefixLength;
    private final String ipAccessControlListSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String uri;

    public static IpAddressReader reader(String pathAccountSid, String pathIpAccessControlListSid) {
        return new IpAddressReader(pathAccountSid, pathIpAccessControlListSid);
    }

    public static IpAddressReader reader(String pathIpAccessControlListSid) {
        return new IpAddressReader(pathIpAccessControlListSid);
    }

    public static IpAddressCreator creator(String pathAccountSid, String pathIpAccessControlListSid, String friendlyName, String ipAddress) {
        return new IpAddressCreator(pathAccountSid, pathIpAccessControlListSid, friendlyName, ipAddress);
    }

    public static IpAddressCreator creator(String pathIpAccessControlListSid, String friendlyName, String ipAddress) {
        return new IpAddressCreator(pathIpAccessControlListSid, friendlyName, ipAddress);
    }

    public static IpAddressFetcher fetcher(String pathAccountSid, String pathIpAccessControlListSid, String pathSid) {
        return new IpAddressFetcher(pathAccountSid, pathIpAccessControlListSid, pathSid);
    }

    public static IpAddressFetcher fetcher(String pathIpAccessControlListSid, String pathSid) {
        return new IpAddressFetcher(pathIpAccessControlListSid, pathSid);
    }

    public static IpAddressUpdater updater(String pathAccountSid, String pathIpAccessControlListSid, String pathSid) {
        return new IpAddressUpdater(pathAccountSid, pathIpAccessControlListSid, pathSid);
    }

    public static IpAddressUpdater updater(String pathIpAccessControlListSid, String pathSid) {
        return new IpAddressUpdater(pathIpAccessControlListSid, pathSid);
    }

    public static IpAddressDeleter deleter(String pathAccountSid, String pathIpAccessControlListSid, String pathSid) {
        return new IpAddressDeleter(pathAccountSid, pathIpAccessControlListSid, pathSid);
    }

    public static IpAddressDeleter deleter(String pathIpAccessControlListSid, String pathSid) {
        return new IpAddressDeleter(pathIpAccessControlListSid, pathSid);
    }

    public static IpAddress fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (IpAddress)objectMapper.readValue(json, IpAddress.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static IpAddress fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (IpAddress)objectMapper.readValue(json, IpAddress.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private IpAddress(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="ip_address") String ipAddress, @JsonProperty(value="cidr_prefix_length") Integer cidrPrefixLength, @JsonProperty(value="ip_access_control_list_sid") String ipAccessControlListSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="uri") String uri) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.ipAddress = ipAddress;
        this.cidrPrefixLength = cidrPrefixLength;
        this.ipAccessControlListSid = ipAccessControlListSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.uri = uri;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getIpAddress() {
        return this.ipAddress;
    }

    public final Integer getCidrPrefixLength() {
        return this.cidrPrefixLength;
    }

    public final String getIpAccessControlListSid() {
        return this.ipAccessControlListSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpAddress other = (IpAddress)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.cidrPrefixLength, other.cidrPrefixLength) && Objects.equals(this.ipAccessControlListSid, other.ipAccessControlListSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.friendlyName, this.ipAddress, this.cidrPrefixLength, this.ipAccessControlListSid, this.dateCreated, this.dateUpdated, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("ipAddress", (Object)this.ipAddress).add("cidrPrefixLength", (Object)this.cidrPrefixLength).add("ipAccessControlListSid", (Object)this.ipAccessControlListSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("uri", (Object)this.uri).toString();
    }
}

